/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.archiver.Archiver;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.job.FileCollisionChecker;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Dialog;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveJob
extends TransferFileJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveJob.class);
    private AbstractFile destFile;
    private String baseFolderPath;
    private Archiver archiver;
    private int archiveFormat;
    private String archiveComment;
    private final Object ioLock = new Object();

    public ArchiveJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destFile, int archiveFormat, String archiveComment) {
        super(progressDialog, mainFrame, files);
        this.destFile = destFile;
        this.archiveFormat = archiveFormat;
        this.archiveComment = archiveComment;
        this.baseFolderPath = this.getBaseSourceFolder().getAbsolutePath(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        String filePath = file.getAbsolutePath(false);
        String entryRelativePath = filePath.substring(this.baseFolderPath.length() + 1, filePath.length());
        while (true) {
            try {
                if (file.isDirectory() && !file.isSymlink()) {
                    this.archiver.createEntry(entryRelativePath, file);
                    AbstractFile[] subFiles = file.ls();
                    boolean folderComplete = true;
                    for (int i = 0; i < subFiles.length && this.getState() != 3; ++i) {
                        this.nextFile(subFiles[i]);
                        if (this.processFile(subFiles[i], null)) continue;
                        folderComplete = false;
                    }
                    return folderComplete;
                }
                InputStream in = this.setCurrentInputStream(file.getInputStream());
                Object folderComplete = this.ioLock;
                synchronized (folderComplete) {
                    StreamUtils.copyStream(in, this.archiver.createEntry(entryRelativePath, file));
                    in.close();
                }
                return true;
            }
            catch (Exception e) {
                if (this.getState() == 3) {
                    return false;
                }
                LOGGER.debug("Caught IOException", e);
                int ret = this.showErrorDialog(Translator.get("pack_dialog.error_title", new String[0]), Translator.get("error_while_transferring", file.getAbsolutePath()));
                if (ret == 2) {
                    this.getCurrentFileByteCounter().reset();
                    continue;
                }
                return false;
            }
            break;
        }
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return folder.equalsCanonical(this.destFile.getParent());
    }

    protected void jobStarted() {
        int choice;
        super.jobStarted();
        int collision = FileCollisionChecker.checkForCollision(null, this.destFile);
        if (collision != 0 && (choice = this.waitForUserResponse(new FileCollisionDialog((Dialog)this.getProgressDialog(), (Component)this.getMainFrame(), collision, null, this.destFile, false, false))) != 2) {
            this.interrupt();
            return;
        }
        while (true) {
            try {
                this.archiver = Archiver.getArchiver(this.destFile, this.archiveFormat);
                this.archiver.setComment(this.archiveComment);
            }
            catch (Exception e) {
                int choice2 = this.showErrorDialog(Translator.get("pack_dialog.error_title", new String[0]), Translator.get("cannot_write_file", this.destFile.getName()), new String[]{CANCEL_TEXT, RETRY_TEXT}, new int[]{3, 2});
                if (choice2 == 2) continue;
                this.interrupt();
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobStopped() {
        super.jobStopped();
        Object object = this.ioLock;
        synchronized (object) {
            if (this.archiver != null) {
                try {
                    this.archiver.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public String getStatusString() {
        return Translator.get("pack_dialog.packing_file", this.getCurrentFilename());
    }
}

