/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.FileCollisionChecker;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.dialog.file.FileCollisionRenameDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Dialog;
import java.io.IOException;

public abstract class AbstractCopyJob
extends TransferFileJob {
    protected AbstractFile baseDestFolder;
    protected String newName;
    protected int defaultFileExistsAction = -1;
    protected String errorDialogTitle;
    protected boolean append;
    protected AbstractRWArchiveFile archiveToOptimize;
    protected boolean isOptimizingArchive;

    public AbstractCopyJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destFolder, String newName, int fileExistsAction) {
        super(progressDialog, mainFrame, files);
        this.baseDestFolder = destFolder;
        this.newName = newName;
        this.defaultFileExistsAction = fileExistsAction;
    }

    protected AbstractFile createDestinationFile(AbstractFile destFolder, String destFileName) {
        AbstractFile destFile;
        while (true) {
            try {
                destFile = destFolder.getDirectChild(destFileName);
            }
            catch (IOException e) {
                int ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_write_file", destFileName));
                if (ret == 2) continue;
                return null;
            }
            break;
        }
        return destFile;
    }

    protected AbstractFile checkForCollision(AbstractFile file, AbstractFile destFolder, AbstractFile destFile, boolean allowCaseVariation) {
        this.append = false;
        while (true) {
            int choice;
            String destFileName;
            String sourceFileName;
            int collision = FileCollisionChecker.checkForCollision(file, destFile);
            if (allowCaseVariation && collision == 2 && (sourceFileName = file.getName()).equalsIgnoreCase(destFileName = destFile.getName()) && !sourceFileName.equals(destFileName) || collision == 0) break;
            if (this.defaultFileExistsAction == -1) {
                FileCollisionDialog dialog = new FileCollisionDialog((Dialog)this.getProgressDialog(), (Component)this.getMainFrame(), collision, file, destFile, true, true);
                choice = this.waitForUserResponse(dialog);
                if (dialog.applyToAllSelected()) {
                    this.defaultFileExistsAction = choice;
                }
            } else {
                choice = this.defaultFileExistsAction;
            }
            if (choice == -1 || choice == 0) {
                this.interrupt();
                return null;
            }
            if (choice == 1) {
                return null;
            }
            if (choice == 4) {
                this.append = true;
                break;
            }
            if (choice == 2) break;
            if (choice == 3) {
                if (file.getDate() > destFile.getDate()) break;
                return null;
            }
            if (choice != 5) break;
            this.setPaused(true);
            FileCollisionRenameDialog dlg = new FileCollisionRenameDialog(this.getMainFrame(), destFile);
            String destFileName2 = (String)this.waitForUserResponseObject(dlg);
            this.setPaused(false);
            if (destFileName2 != null) {
                destFile = this.createDestinationFile(destFolder, destFileName2);
                continue;
            }
            this.defaultFileExistsAction = -1;
        }
        return destFile;
    }

    protected void optimizeArchive(AbstractRWArchiveFile rwArchiveFile) {
        this.isOptimizingArchive = true;
        while (true) {
            try {
                this.archiveToOptimize = rwArchiveFile;
                this.archiveToOptimize.optimizeArchive();
            }
            catch (IOException e) {
                if (this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_optimizing_archive", rwArchiveFile.getName())) == 2) continue;
            }
            break;
        }
        this.isOptimizingArchive = false;
    }
}

