/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.io.backup;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import java.io.IOException;
import java.io.OutputStream;

public class BackupOutputStream
extends OutputStream {
    private OutputStream out;
    private AbstractFile target;
    private AbstractFile backup;
    private boolean error;

    public BackupOutputStream(AbstractFile file) throws IOException {
        this(file, FileFactory.getFile(file.getAbsolutePath() + '~'));
    }

    private BackupOutputStream(AbstractFile file, AbstractFile save) throws IOException {
        this.out = save.getOutputStream();
        this.target = file;
        this.backup = save;
    }

    public void flush() throws IOException {
        if (this.error) {
            this.out.flush();
        } else {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.error) {
            this.out.write(b);
        } else {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.error) {
            this.out.write(b, off, len);
        } else {
            try {
                this.out.write(b, off, len);
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
        }
    }

    public void write(int b) throws IOException {
        if (this.error) {
            this.out.write(b);
        } else {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
        }
    }

    private void backup() throws IOException {
        if (this.target.exists()) {
            this.target.delete();
        }
        this.backup.copyTo(this.target);
        this.backup.delete();
    }

    public void close() throws IOException {
        this.close(!this.error);
    }

    public void close(boolean backup) throws IOException {
        this.out.flush();
        this.out.close();
        if (backup) {
            this.backup();
        }
    }
}

