/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.extension;

import com.mucommander.extension.ClassFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.swing.LookAndFeel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelFilter
implements ClassFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookAndFeelFilter.class);

    @Override
    public boolean accept(Class<?> c) {
        Constructor<?> constructor;
        if (c.getDeclaringClass() != null) {
            return false;
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers)) {
            return false;
        }
        try {
            constructor = c.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return false;
        }
        for (Class<?> buffer = c; buffer != null; buffer = buffer.getSuperclass()) {
            if (!buffer.equals(LookAndFeel.class)) continue;
            try {
                return ((LookAndFeel)c.newInstance()).isSupportedLookAndFeel();
            }
            catch (Throwable e) {
                LOGGER.debug("Caught exception", e);
                return false;
            }
        }
        return false;
    }
}

