/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.extension;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractFileClassLoader;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.ExtensionFilenameFilter;
import com.mucommander.commons.file.filter.OrFileFilter;
import com.mucommander.extension.ClassFilter;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private ClassLoader loader;
    private OrFileFilter filter = new OrFileFilter(new ExtensionFilenameFilter(".class"), new AttributeFileFilter(0));
    private ClassFilter classFilter;

    private List<Class<?>> find(String currentPackage, AbstractFile currentFile) throws IOException {
        AbstractFile[] files;
        Vector result = new Vector();
        for (AbstractFile file : files = currentFile.ls(this.filter)) {
            if (file.isDirectory()) {
                result.addAll(this.find(currentPackage + file.getName() + '.', file));
                continue;
            }
            try {
                Class<?> currentClass = Class.forName(currentPackage + file.getNameWithoutExtension(), false, this.loader);
                if (!this.classFilter.accept(currentClass)) continue;
                result.add(currentClass);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return result;
    }

    public List<Class<?>> find(AbstractFile browsable, ClassFilter classFilter, ClassLoader classLoader) throws IOException {
        if (!browsable.isBrowsable()) {
            return new Vector();
        }
        this.loader = classLoader;
        this.classFilter = classFilter;
        return this.find("", browsable);
    }

    public List<Class<?>> find(AbstractFile browsable, ClassFilter classFilter) throws IOException {
        AbstractFileClassLoader classLoader = new AbstractFileClassLoader();
        classLoader.addFile(browsable);
        return this.find(browsable, classFilter, classLoader);
    }
}

