/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.xfce;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.desktop.QueuedTrash;
import com.mucommander.job.DeleteJob;
import com.mucommander.process.ProcessRunner;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XfceTrash
extends QueuedTrash {
    private static final Logger LOGGER = LoggerFactory.getLogger(XfceTrash.class);
    private static final AbstractFile TRASH_FOLDER;
    private static final AbstractFile TRASH_INFO_SUBFOLDER;
    private static final AbstractFile TRASH_FILES_SUBFOLDER;
    private static final AbstractFile TRASH_VOLUME;
    private static final SimpleDateFormat INFO_DATE_FORMAT;

    private static AbstractFile getTrashFolder() {
        AbstractFile userHome = LocalFile.getUserHome();
        AbstractFile trashDir = userHome.getChildSilently(".local/share/Trash/");
        if (XfceTrash.isTrashFolder(trashDir)) {
            return trashDir;
        }
        if (!trashDir.exists()) {
            try {
                trashDir.mkdirs();
                trashDir.getChild("info").mkdir();
                trashDir.getChild("files").mkdir();
                return trashDir;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isTrashFolder(AbstractFile file) {
        try {
            return file.isDirectory() && file.getChild("info").isDirectory() && file.getChild("files").isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean moveToTrash(List<AbstractFile> queuedFiles) {
        int nbFiles = queuedFiles.size();
        boolean retVal = true;
        for (int i = 0; i < nbFiles; ++i) {
            String trashFileName;
            String fileInfoContent;
            AbstractFile fileToDelete = queuedFiles.get(i);
            try {
                fileInfoContent = this.getFileInfoContent(fileToDelete);
                trashFileName = this.getUniqueFilename(fileToDelete);
            }
            catch (IOException ex) {
                LOGGER.debug("Failed to create filename for new trash item: " + fileToDelete.getName(), ex);
                continue;
            }
            AbstractFile infoFile = null;
            OutputStreamWriter infoWriter = null;
            try {
                infoFile = TRASH_INFO_SUBFOLDER.getChild(trashFileName + ".trashinfo");
                infoWriter = new OutputStreamWriter(infoFile.getOutputStream());
                infoWriter.write(fileInfoContent);
            }
            catch (IOException ex) {
                retVal = false;
                LOGGER.debug("Failed to create trash info file: " + trashFileName, ex);
                continue;
            }
            finally {
                if (infoWriter != null) {
                    try {
                        infoWriter.close();
                    }
                    catch (IOException e) {}
                }
            }
            try {
                fileToDelete.renameTo(TRASH_FILES_SUBFOLDER.getChild(trashFileName));
                continue;
            }
            catch (IOException ex) {
                try {
                    infoFile.delete();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                retVal = false;
                LOGGER.debug("Failed to move file to trash: " + trashFileName, ex);
            }
        }
        return retVal;
    }

    @Override
    public boolean canMoveToTrash(AbstractFile file) {
        return TRASH_FOLDER != null && file.getTopAncestor() instanceof LocalFile && file.getVolume().equals(TRASH_VOLUME);
    }

    @Override
    public boolean canEmpty() {
        return TRASH_FOLDER != null;
    }

    @Override
    public boolean empty() {
        if (TRASH_FOLDER == null) {
            return false;
        }
        FileSet filesToDelete = new FileSet(TRASH_FOLDER);
        try {
            filesToDelete.addAll(TRASH_FILES_SUBFOLDER.ls());
            filesToDelete.addAll(TRASH_INFO_SUBFOLDER.ls());
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to list files", ex);
            return false;
        }
        if (filesToDelete.size() > 0) {
            MainFrame mainFrame = WindowManager.getCurrentMainFrame();
            ProgressDialog progressDialog = new ProgressDialog(mainFrame, Translator.get("delete_dialog.deleting", new String[0]));
            DeleteJob deleteJob = new DeleteJob(progressDialog, mainFrame, filesToDelete, false);
            progressDialog.start(deleteJob);
        }
        return true;
    }

    @Override
    public boolean isTrashFile(AbstractFile file) {
        return TRASH_FOLDER != null && file.getTopAncestor() instanceof LocalFile && TRASH_FOLDER.isParentOf(file);
    }

    @Override
    public int getItemCount() {
        if (TRASH_FOLDER == null) {
            return -1;
        }
        try {
            return TRASH_INFO_SUBFOLDER.ls().length;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    @Override
    public void open() {
        try {
            ProcessRunner.execute("thunar trash:///").waitFor();
        }
        catch (Exception e) {
            LOGGER.debug("Caught an exception running command \"thunar trash:///\"", e);
        }
    }

    @Override
    public boolean canOpen() {
        return TRASH_FOLDER != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileInfoContent(AbstractFile file) {
        SimpleDateFormat simpleDateFormat = INFO_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return "[Trash Info]\nPath=" + file.getAbsolutePath() + "\n" + "DeletionDate=" + INFO_DATE_FORMAT.format(new Date());
        }
    }

    private String getUniqueFilename(AbstractFile file) throws IOException {
        String filename;
        if (!TRASH_FILES_SUBFOLDER.getChild(file.getName()).exists()) {
            return file.getName();
        }
        String rawName = file.getNameWithoutExtension();
        String extension = file.getExtension();
        int count = 1;
        do {
            filename = rawName + "_" + count++;
            if (extension == null) continue;
            filename = filename + "." + extension;
        } while (TRASH_FILES_SUBFOLDER.getChild(filename).exists());
        return filename;
    }

    static {
        INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TRASH_FOLDER = XfceTrash.getTrashFolder();
        if (TRASH_FOLDER != null) {
            TRASH_INFO_SUBFOLDER = TRASH_FOLDER.getChildSilently("info");
            TRASH_FILES_SUBFOLDER = TRASH_FOLDER.getChildSilently("files");
            TRASH_VOLUME = TRASH_FOLDER.getVolume();
        } else {
            TRASH_INFO_SUBFOLDER = null;
            TRASH_FILES_SUBFOLDER = null;
            TRASH_VOLUME = null;
        }
    }
}

