/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.windows;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.impl.local.SpecialWindowsLocation;
import com.mucommander.commons.file.util.Shell32;
import com.mucommander.commons.file.util.Shell32API;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.desktop.QueuedTrash;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsTrash
extends QueuedTrash {
    @Override
    public boolean canMoveToTrash(AbstractFile file) {
        return file.getTopAncestor() instanceof LocalFile;
    }

    @Override
    public boolean canEmpty() {
        return true;
    }

    @Override
    public boolean empty() {
        return Shell32.isAvailable() && Shell32.getInstance().SHEmptyRecycleBin(null, null, 1) == 0;
    }

    @Override
    public boolean isTrashFile(AbstractFile file) {
        return false;
    }

    @Override
    public int getItemCount() {
        if (!Shell32.isAvailable()) {
            return -1;
        }
        Shell32API.SHQUERYRBINFO queryRbInfo = new Shell32API.SHQUERYRBINFO();
        int ret = Shell32.getInstance().SHQueryRecycleBin(null, queryRbInfo);
        return ret == 0 ? (int)queryRbInfo.i64NumItems : -1;
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    public void open() {
        try {
            DesktopManager.openInFileManager(SpecialWindowsLocation.RECYCLE_BIN);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected boolean moveToTrash(List<AbstractFile> queuedFiles) {
        if (!Shell32.isAvailable()) {
            return false;
        }
        Shell32API.SHFILEOPSTRUCT fileop = new Shell32API.SHFILEOPSTRUCT();
        fileop.wFunc = 3;
        fileop.fFlags = (short)84;
        int nbFiles = queuedFiles.size();
        String[] paths = new String[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            paths[i] = queuedFiles.get(i).getAbsolutePath(false);
        }
        fileop.pFrom = fileop.encodePaths(paths);
        return Shell32.getInstance().SHFileOperation(fileop) == 0;
    }
}

