/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.windows;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.OsFamily;
import com.mucommander.desktop.DefaultDesktopAdapter;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.desktop.windows.WindowsTrashProvider;

class WindowsDesktopAdapter
extends DefaultDesktopAdapter {
    WindowsDesktopAdapter() {
    }

    public String toString() {
        return "Windows Desktop";
    }

    public void init(boolean install) throws DesktopInitialisationException {
        if (WindowsTrashProvider.isAvailable()) {
            DesktopManager.setTrashProvider(new WindowsTrashProvider());
        }
    }

    public boolean isAvailable() {
        return OsFamily.getCurrent().equals(OsFamily.WINDOWS);
    }

    public boolean isApplication(AbstractFile file) {
        String extension = file.getExtension();
        return extension != null && extension.equalsIgnoreCase("exe") && !file.isDirectory();
    }
}

