/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.windows;

import com.mucommander.command.Command;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.commons.runtime.OsVersion;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.windows.WindowsDesktopAdapter;

public class Win9xDesktopAdapter
extends WindowsDesktopAdapter {
    public String toString() {
        return "Windows 9x Desktop";
    }

    public boolean isAvailable() {
        return super.isAvailable() && OsVersion.getCurrent().compareTo(OsVersion.WINDOWS_NT) < 0;
    }

    public void init(boolean install) throws DesktopInitialisationException {
        super.init(install);
        try {
            CommandManager.registerDefaultCommand(new Command("open", "start \"$f\"", 1, null));
            CommandManager.registerDefaultCommand(new Command("openURL", "start \"$f\"", 1, null));
            CommandManager.registerDefaultCommand(new Command("openFM", "start \"$f\"", 1, "Explorer"));
        }
        catch (CommandException e) {
            throw new DesktopInitialisationException(e);
        }
    }

    public String getDefaultShell() {
        return "command.com /c";
    }
}

