/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.osx;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.desktop.QueuedTrash;
import com.mucommander.ui.macosx.AppleScript;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSXTrash
extends QueuedTrash {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSXTrash.class);

    @Override
    public boolean canMoveToTrash(AbstractFile file) {
        return file.getTopAncestor() instanceof LocalFile;
    }

    @Override
    public boolean canEmpty() {
        return true;
    }

    @Override
    public boolean empty() {
        return AppleScript.execute("tell application \"Finder\" to empty trash", null);
    }

    @Override
    public boolean isTrashFile(AbstractFile file) {
        return file.getTopAncestor() instanceof LocalFile && file.getAbsolutePath(true).indexOf("/.Trash/") != -1;
    }

    @Override
    public int getItemCount() {
        StringBuilder output = new StringBuilder();
        if (!AppleScript.execute("tell application \"Finder\" to return count of items in trash", output)) {
            return -1;
        }
        try {
            return Integer.parseInt(output.toString().trim());
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Caught an exception", e);
            return -1;
        }
    }

    @Override
    public void open() {
        AppleScript.execute("tell application \"Finder\" to open trash\nactivate application \"Finder\"\n", null);
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    protected boolean moveToTrash(List<AbstractFile> queuedFiles) {
        if (AppleScript.getScriptEncoding().equals("UTF-8")) {
            int nbFiles = queuedFiles.size();
            String appleScript = "tell application \"Finder\" to move {";
            for (int i = 0; i < nbFiles; ++i) {
                appleScript = appleScript + "posix file \"" + queuedFiles.get(i).getAbsolutePath() + "\"";
                if (i >= nbFiles - 1) continue;
                appleScript = appleScript + ", ";
            }
            appleScript = appleScript + "} to the trash";
            return AppleScript.execute(appleScript, null);
        }
        AbstractFile tmpFile = null;
        OutputStreamWriter tmpOut = null;
        try {
            int nbFiles = queuedFiles.size();
            tmpFile = FileFactory.getTemporaryFile("trash_files.muco", false);
            tmpOut = new OutputStreamWriter(tmpFile.getOutputStream(), "utf-8");
            for (int i = 0; i < nbFiles; ++i) {
                tmpOut.write(queuedFiles.get(i).getAbsolutePath());
                if (i >= nbFiles - 1) continue;
                tmpOut.write("\n");
            }
            tmpOut.close();
            String appleScript = "set tmpFilePath to \"" + tmpFile.getAbsolutePath() + "\"\n";
            appleScript = appleScript + "set tmpFile to (open for access (POSIX file tmpFilePath))\nset tmpFileContents to (read tmpFile for (get eof tmpFile) as \u00abclass utf8\u00bb)\nclose access tmpFile\nset posixFileList to every paragraph of tmpFileContents\nset fileCount to the number of items in posixFileList\nset fileList to {}\nrepeat with i from 1 to the fileCount\nset posixFile to item i of posixFileList\ncopy POSIX file posixFile to the end of fileList\nend repeat\ntell application \"Finder\" to move fileList to the trash";
            boolean success = AppleScript.execute(appleScript, null);
            tmpFile.delete();
            return success;
        }
        catch (IOException e) {
            LOGGER.debug("Caught IOException", e);
            if (tmpOut != null) {
                try {
                    tmpOut.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            if (tmpFile != null) {
                try {
                    tmpFile.delete();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

