/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.gnome;

import com.mucommander.command.Command;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.commons.file.filter.RegexpFilenameFilter;
import com.mucommander.desktop.DefaultDesktopAdapter;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.desktop.gnome.GnomeConfig;
import com.mucommander.desktop.gnome.GnomeTrashProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GnomeDesktopAdapter
extends DefaultDesktopAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GnomeDesktopAdapter.class);
    private int multiClickInterval;
    private String DOUBLE_CLICK_CONFIG_KEY = "/desktop/gnome/peripherals/mouse/double_click";

    GnomeDesktopAdapter() {
    }

    public void init(boolean install) throws DesktopInitialisationException {
        DesktopManager.setTrashProvider(new GnomeTrashProvider());
        try {
            CommandManager.registerDefaultCommand(new Command("open", "gnome-open $f", 1, null));
            CommandManager.registerDefaultCommand(new Command("openURL", "gnome-open $f", 1, null));
            CommandManager.registerDefaultCommand(new Command("openEXE", "$f", 1, null));
            CommandManager.registerDefaultCommand(new Command("openFM", "gnome-open $f", 1, "Nautilus"));
            RegexpFilenameFilter filter = new RegexpFilenameFilter("[^.]+", true);
            CommandManager.registerDefaultAssociation("openEXE", filter);
            try {
                String value = GnomeConfig.getValue(this.DOUBLE_CLICK_CONFIG_KEY);
                if (value == null) {
                    this.multiClickInterval = super.getMultiClickInterval();
                }
                this.multiClickInterval = Integer.parseInt(value);
            }
            catch (Exception e) {
                LOGGER.debug("Error while retrieving double-click interval from gconftool", e);
                this.multiClickInterval = super.getMultiClickInterval();
            }
        }
        catch (CommandException e) {
            throw new DesktopInitialisationException(e);
        }
    }

    public int getMultiClickInterval() {
        return this.multiClickInterval;
    }
}

