/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.gnome;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnomeConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GnomeConfig.class);
    private static String CONFIG_COMMAND = "gconftool";

    public static String getValue(String key) throws IOException {
        BufferedReader br = null;
        try {
            Process process = Runtime.getRuntime().exec(CONFIG_COMMAND + " -g " + key);
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            LOGGER.debug(CONFIG_COMMAND + " returned '" + line + "' for " + key);
            if (line == null || (line = line.trim()).equals("") || line.startsWith("No value set for")) {
                String string = null;
                return string;
            }
            String string = line;
            return string;
        }
        catch (IOException e) {
            LOGGER.debug("Error while retrieving value for " + key, e);
            throw e;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

