/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.LocalFileOperation;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

class InternalOpen
extends LocalFileOperation {
    private Desktop desktop;
    private boolean initialized = false;

    private Desktop getDesktop() {
        if (!this.initialized) {
            if (Desktop.isDesktopSupported()) {
                this.desktop = Desktop.getDesktop();
            }
            this.initialized = true;
        }
        return this.desktop;
    }

    public boolean isAvailable() {
        return this.getDesktop() != null && this.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    public void execute(AbstractFile file) throws IOException {
        if (!this.isAvailable()) {
            throw new UnsupportedOperationException();
        }
        this.getDesktop().open(new File(file.getAbsolutePath()));
    }

    public String getName() {
        return "java.awt.Desktop open file";
    }
}

