/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.DesktopAdapter;
import com.mucommander.desktop.DesktopInitialisationException;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDesktopAdapter
implements DesktopAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDesktopAdapter.class);
    private static int multiClickInterval;

    public String toString() {
        return "Default Desktop";
    }

    public boolean isAvailable() {
        return true;
    }

    public void init(boolean install) throws DesktopInitialisationException {
    }

    public boolean isLeftMouseButton(MouseEvent e) {
        return (e.getModifiers() & 0x10) != 0;
    }

    public boolean isRightMouseButton(MouseEvent e) {
        return (e.getModifiers() & 4) != 0;
    }

    public boolean isMiddleMouseButton(MouseEvent e) {
        return (e.getModifiers() & 8) != 0;
    }

    public int getMultiClickInterval() {
        return multiClickInterval;
    }

    public String getDefaultShell() {
        return "/bin/sh -l -c";
    }

    public boolean isApplication(AbstractFile file) {
        return false;
    }

    static {
        try {
            Integer n = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
            multiClickInterval = n == null ? 500 : n;
        }
        catch (Exception exception) {
            LOGGER.debug("Error while retrieving multi-click interval value desktop property", exception);
            multiClickInterval = 500;
        }
    }
}

