/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.command.Command;
import com.mucommander.command.CommandManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.LocalFileOperation;
import com.mucommander.process.ProcessRunner;
import java.io.IOException;

class CommandOpen
extends LocalFileOperation {
    private boolean allowDefault;

    public CommandOpen(boolean allowDefault) {
        this.allowDefault = allowDefault;
    }

    public boolean isAvailable() {
        if (this.allowDefault) {
            return true;
        }
        return CommandManager.getCommandForAlias("open") != null;
    }

    public boolean canExecute(AbstractFile file) {
        if (this.allowDefault) {
            return true;
        }
        return CommandManager.getCommandForFile(file, false) != null;
    }

    public void execute(AbstractFile file) throws IOException {
        Command command = CommandManager.getCommandForFile(file, this.allowDefault);
        if (command == null) {
            throw new UnsupportedOperationException();
        }
        ProcessRunner.execute(command.getTokens(file), file);
    }

    public String getName() {
        return "open bridge";
    }
}

