/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.conf;

import com.mucommander.commons.conf.Configuration;
import com.mucommander.commons.conf.ConfigurationException;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuSnapshotFile;
import com.mucommander.conf.VersionedXmlConfigurationReader;
import com.mucommander.conf.VersionedXmlConfigurationReaderFactory;
import com.mucommander.conf.VersionedXmlConfigurationWriterFactory;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.tabs.FileTableTab;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuSnapshot.class);
    private Dimension screenSize;
    private final Configuration configuration = new Configuration(MuSnapshotFile.getSnapshotFile(), new VersionedXmlConfigurationReaderFactory(), new VersionedXmlConfigurationWriterFactory("snapshot"));

    public static String getSelectedWindow() {
        return "windows.selection";
    }

    private static String getWindowSection(int index) {
        return "windows.window-" + index;
    }

    private static String getWindowPropertiesSection(int window) {
        return MuSnapshot.getWindowSection(window) + "." + "window_properties";
    }

    public static String getX(int window) {
        return MuSnapshot.getWindowPropertiesSection(window) + "." + "x";
    }

    public static String getY(int window) {
        return MuSnapshot.getWindowPropertiesSection(window) + "." + "y";
    }

    public static String getWidth(int window) {
        return MuSnapshot.getWindowPropertiesSection(window) + "." + "width";
    }

    public static String getHeight(int window) {
        return MuSnapshot.getWindowPropertiesSection(window) + "." + "height";
    }

    public static String getSplitOrientation(int window) {
        return MuSnapshot.getWindowPropertiesSection(window) + "." + "split_orientation";
    }

    private static String getFolderPanelSection(int window, boolean left) {
        return MuSnapshot.getWindowSection(window) + "." + "panels" + "." + (left ? "left" : "right");
    }

    private static String getTreeSection(int window, boolean left) {
        return MuSnapshot.getFolderPanelSection(window, left) + "." + "tree";
    }

    public static String getTreeVisiblityVariable(int window, boolean left) {
        return MuSnapshot.getTreeSection(window, left) + "." + "visible";
    }

    public static String getTreeWidthVariable(int window, boolean left) {
        return MuSnapshot.getTreeSection(window, left) + "." + "width";
    }

    private static String getFileTableSection(int window, boolean left) {
        return MuSnapshot.getFolderPanelSection(window, left) + "." + "file_table";
    }

    private static String getFileTableSortSection(int window, boolean left) {
        return MuSnapshot.getFileTableSection(window, left) + "." + "sort";
    }

    public static String getFileTableSortByVariable(int window, boolean left) {
        return MuSnapshot.getFileTableSortSection(window, left) + "." + "by";
    }

    public static String getFileTableSortOrderVariable(int window, boolean left) {
        return MuSnapshot.getFileTableSortSection(window, left) + "." + "order";
    }

    private static String getColumnSection(int window, Column column, boolean left) {
        return MuSnapshot.getFileTableSection(window, left) + "." + column.toString().toLowerCase();
    }

    public static String getShowColumnVariable(int window, Column column, boolean left) {
        return MuSnapshot.getColumnSection(window, column, left) + "." + "show";
    }

    public static String getColumnWidthVariable(int window, Column column, boolean left) {
        return MuSnapshot.getColumnSection(window, column, left) + "." + "width";
    }

    public static String getColumnPositionVariable(int window, Column column, boolean left) {
        return MuSnapshot.getColumnSection(window, column, left) + "." + "position";
    }

    private static String getTabsSection(int window, boolean left) {
        return MuSnapshot.getFolderPanelSection(window, left) + "." + "tabs";
    }

    public static String getTabsCountVariable(int window, boolean left) {
        return MuSnapshot.getTabsSection(window, left) + "." + "count";
    }

    private static String getTabSection(int window, boolean left, int index) {
        return MuSnapshot.getTabsSection(window, left) + "." + "tab" + "-" + index;
    }

    public static String getTabLocationVariable(int window, boolean left, int index) {
        return MuSnapshot.getTabSection(window, left, index) + "." + "location";
    }

    MuSnapshot() {
        try {
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (HeadlessException e) {
            LOGGER.debug("Could not fetch screen size: " + e.getMessage());
        }
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    void read() throws IOException, ConfigurationException {
        VersionedXmlConfigurationReader reader = new VersionedXmlConfigurationReader();
        this.configuration.read(reader);
    }

    void write() throws IOException, ConfigurationException {
        this.configuration.clear();
        List<MainFrame> mainFrames = WindowManager.getMainFrames();
        int nbMainFrames = mainFrames.size();
        this.configuration.setVariable("windows.count", nbMainFrames);
        int indexOfSelectedWindow = WindowManager.getCurrentWindowIndex();
        this.configuration.setVariable("windows.selection", indexOfSelectedWindow);
        for (int i = 0; i < nbMainFrames; ++i) {
            this.setFrameAttributes(mainFrames.get(i), i);
        }
        this.configuration.write();
    }

    private void setFrameAttributes(MainFrame mainFrame, int index) {
        this.setWindowAttributes(index, mainFrame);
        this.setPanelAttributes(index, true, mainFrame.getLeftPanel());
        this.setPanelAttributes(index, false, mainFrame.getRightPanel());
    }

    private void setPanelAttributes(int index, boolean isLeft, FolderPanel panel) {
        this.setTreeAttributes(index, isLeft, panel);
        this.setTableAttributes(index, isLeft, panel.getFileTable());
        this.setTabsAttributes(index, isLeft, panel.getTabs().getClonedTabs());
    }

    private void setTabsAttributes(int index, boolean isLeft, List<FileTableTab> tabs) {
        this.configuration.setVariable(MuSnapshot.getTabsCountVariable(index, isLeft), tabs.size());
        for (int i = 0; i < tabs.size(); ++i) {
            FileTableTab tab = tabs.get(i);
            this.configuration.setVariable(MuSnapshot.getTabLocationVariable(index, isLeft, i), tab.getLocation().getAbsolutePath());
        }
    }

    private void setTableAttributes(int index, boolean isLeft, FileTable table) {
        this.configuration.setVariable(MuSnapshot.getFileTableSortByVariable(index, isLeft), table.getSortInfo().getCriterion().toString().toLowerCase());
        this.configuration.setVariable(MuSnapshot.getFileTableSortOrderVariable(index, isLeft), table.getSortInfo().getAscendingOrder() ? "asc" : "desc");
        for (Column c : Column.values()) {
            if (c != Column.NAME) {
                MuConfigurations.getSnapshot().setVariable(MuSnapshot.getShowColumnVariable(index, c, isLeft), table.isColumnEnabled(c));
                MuConfigurations.getSnapshot().setVariable(MuSnapshot.getColumnWidthVariable(index, c, isLeft), table.getColumnWidth(c));
            }
            MuConfigurations.getSnapshot().setVariable(MuSnapshot.getColumnPositionVariable(index, c, isLeft), table.getColumnPosition(c));
        }
    }

    private void setTreeAttributes(int index, boolean isLeft, FolderPanel panel) {
        this.configuration.setVariable(MuSnapshot.getTreeVisiblityVariable(index, isLeft), panel.isTreeVisible());
        this.configuration.setVariable(MuSnapshot.getTreeWidthVariable(index, isLeft), panel.getTreeWidth());
    }

    private void setWindowAttributes(int index, MainFrame currentMainFrame) {
        Rectangle bounds = currentMainFrame.getBounds();
        this.configuration.setVariable(MuSnapshot.getX(index), (int)bounds.getX());
        this.configuration.setVariable(MuSnapshot.getY(index), (int)bounds.getY());
        this.configuration.setVariable(MuSnapshot.getWidth(index), (int)bounds.getWidth());
        this.configuration.setVariable(MuSnapshot.getHeight(index), (int)bounds.getHeight());
        if (this.screenSize != null) {
            this.configuration.setVariable("screen.width", this.screenSize.width);
            this.configuration.setVariable("screen.height", this.screenSize.height);
        }
        this.configuration.setVariable(MuSnapshot.getSplitOrientation(index), currentMainFrame.getSplitPane().getOrientation() == 1 ? "vertical" : "horizontal");
    }
}

