/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.conf;

import com.mucommander.RuntimeConstants;
import com.mucommander.commons.conf.Configuration;
import com.mucommander.commons.conf.ConfigurationException;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.conf.ValueList;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.conf.MuPreference;
import com.mucommander.conf.MuPreferencesAPI;
import com.mucommander.conf.MuPreferencesFile;
import com.mucommander.conf.VersionedXmlConfigurationReader;
import com.mucommander.conf.VersionedXmlConfigurationReaderFactory;
import com.mucommander.conf.VersionedXmlConfigurationWriterFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuPreferences
implements MuPreferencesAPI {
    public static final boolean DEFAULT_ENABLE_SYSTEM_NOTIFICATIONS = OsFamilies.MAC_OS_X.isCurrent() || OsFamilies.WINDOWS.isCurrent() && JavaVersions.JAVA_1_6.isCurrentOrHigher();
    private Configuration configuration = new Configuration(MuPreferencesFile.getPreferencesFile(), new VersionedXmlConfigurationReaderFactory(), new VersionedXmlConfigurationWriterFactory("preferences"));
    private String configurationVersion;

    MuPreferences() {
    }

    void read() throws IOException, ConfigurationException {
        VersionedXmlConfigurationReader reader = new VersionedXmlConfigurationReader();
        this.configuration.read(reader);
        this.configurationVersion = reader.getVersion();
        if (this.configurationVersion == null || !this.configurationVersion.equals(RuntimeConstants.VERSION)) {
            this.configuration.renameVariable("show_hidden_files", "file_table.show_hidden_files");
            this.configuration.renameVariable("auto_size_columns", "file_table.auto_size_columns");
            this.configuration.renameVariable("show_toolbar", "toolbar.visible");
            this.configuration.renameVariable("show_status_bar", "status_bar.visible");
            this.configuration.renameVariable("show_command_bar", "command_bar.visible");
        }
        if (OsFamilies.MAC_OS_X.isCurrent() && this.configuration.getVariable("shell.encoding") == null) {
            this.configuration.setVariable("shell.encoding", "UTF-8");
            this.configuration.setVariable("shell.autodect_encoding", false);
        }
    }

    void write() throws IOException, ConfigurationException {
        if (this.configurationVersion != null && !this.configurationVersion.equals(RuntimeConstants.VERSION)) {
            Configuration conf = new Configuration(MuPreferencesFile.getPreferencesFile(), new VersionedXmlConfigurationReaderFactory(), new VersionedXmlConfigurationWriterFactory("preferences"));
            for (MuPreference preference : MuPreference.values()) {
                conf.setVariable(preference.toString(), this.configuration.getVariable(preference.toString()));
            }
            if (!OsFamilies.MAC_OS_X.isCurrent()) {
                conf.removeVariable("macosx.brushed_metal_look");
                conf.removeVariable("macosx.screen_menu_bar");
            }
            this.configuration = conf;
        }
        this.configuration.write();
    }

    void addConfigurationListener(ConfigurationListener listener) {
        this.configuration.addConfigurationListener(listener);
    }

    void setConfigurationFile(String file) throws FileNotFoundException {
        this.configuration.setSource(MuPreferencesFile.getPreferencesFile(file));
    }

    boolean isFileExists() throws IOException {
        return this.configuration.getSource().isExists();
    }

    @Override
    public boolean setVariable(MuPreference preference, String value) {
        return this.configuration.setVariable(preference.toString(), value);
    }

    @Override
    public boolean setVariable(MuPreference preference, List<String> value, String separator) {
        return this.configuration.setVariable(preference.toString(), value, separator);
    }

    @Override
    public boolean setVariable(MuPreference preference, float value) {
        return this.configuration.setVariable(preference.toString(), value);
    }

    @Override
    public boolean setVariable(MuPreference preference, boolean value) {
        return this.configuration.setVariable(preference.toString(), value);
    }

    @Override
    public String getVariable(MuPreference preference) {
        return this.configuration.getVariable(preference.toString());
    }

    @Override
    public String getVariable(MuPreference preference, String value) {
        return this.configuration.getVariable(preference.toString(), value);
    }

    @Override
    public int getVariable(MuPreference preference, int value) {
        return this.configuration.getVariable(preference.toString(), value);
    }

    @Override
    public float getVariable(MuPreference preference, float value) {
        return this.configuration.getVariable(preference.toString(), value);
    }

    @Override
    public boolean getVariable(MuPreference preference, boolean value) {
        return this.configuration.getVariable(preference.toString(), value);
    }

    @Override
    public long getVariable(MuPreference preference, long value) {
        return this.configuration.getVariable(preference.toString(), value);
    }

    @Override
    public ValueList getListVariable(MuPreference preference, String separator) {
        return this.configuration.getListVariable(preference.toString(), separator);
    }

    @Override
    public boolean getBooleanVariable(String name) {
        return this.configuration.getBooleanVariable(name);
    }

    @Override
    public String getVariable(String name) {
        return this.configuration.getVariable(name);
    }

    @Override
    public boolean isVariableSet(MuPreference preference) {
        return this.configuration.isVariableSet(preference.toString());
    }

    @Override
    public String removeVariable(String name) {
        return this.configuration.removeVariable(name);
    }
}

