/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.conf;

import com.mucommander.commons.conf.Configuration;
import com.mucommander.commons.conf.ConfigurationException;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.conf.MuPreferences;
import com.mucommander.conf.MuPreferencesAPI;
import com.mucommander.conf.MuSnapshot;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MuConfigurations {
    private static final MuPreferences preferences = new MuPreferences();
    private static final MuSnapshot snapshot = new MuSnapshot();

    public static MuPreferencesAPI getPreferences() {
        return preferences;
    }

    public static void loadPreferences() throws IOException, ConfigurationException {
        preferences.read();
    }

    public static void savePreferences() throws IOException, ConfigurationException {
        preferences.write();
    }

    public static void setPreferencesFile(String path) throws FileNotFoundException {
        preferences.setConfigurationFile(path);
    }

    public static boolean isPreferencesFileExists() throws IOException {
        return preferences.isFileExists();
    }

    public static void addPreferencesListener(ConfigurationListener listener) {
        preferences.addConfigurationListener(listener);
    }

    public static Configuration getSnapshot() {
        return snapshot.getConfiguration();
    }

    public static void loadSnapshot() throws IOException, ConfigurationException {
        snapshot.read();
    }

    public static void saveSnapshot() throws IOException, ConfigurationException {
        snapshot.write();
    }
}

