/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.util;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean endsWithIgnoreCase(String a, String b) {
        return StringUtils.matchesIgnoreCase(a, b, a.length());
    }

    public static boolean matchesIgnoreCase(String a, String b, int posA) {
        int posB = b.length();
        if (posA < posB) {
            return false;
        }
        while (posB > 0) {
            char cB;
            char cA;
            if (!Character.isLowerCase(cA = a.charAt(--posA))) {
                cA = Character.toLowerCase(cA);
            }
            if (!Character.isLowerCase(cB = b.charAt(--posB))) {
                cB = Character.toLowerCase(cB);
            }
            if (cA == cB) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesIgnoreCase(String a, char[] b, int posA) {
        int posB = b.length;
        if (posA < posB) {
            return false;
        }
        while (posB > 0) {
            char cB;
            char cA;
            if (!Character.isLowerCase(cA = a.charAt(--posA))) {
                cA = Character.toLowerCase(cA);
            }
            if (!Character.isLowerCase(cB = b[--posB])) {
                cB = Character.toLowerCase(cB);
            }
            if (cA == cB) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(String a, char[] b, int posA) {
        int posB = b.length;
        if (posA < posB) {
            return false;
        }
        while (posB > 0) {
            if (a.charAt(--posA) == b[--posB]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String a, String b) {
        return a.regionMatches(true, 0, b, 0, b.length());
    }

    public static boolean equals(String s1, String s2, boolean caseSensitive) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (caseSensitive) {
            return s1 != null && s1.equals(s2);
        }
        return s1 != null && s1.equalsIgnoreCase(s2);
    }

    public static int parseIntDef(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder(s.length());
        out.append(Character.toUpperCase(s.charAt(0)));
        if (s.length() > 1) {
            out.append(s.substring(1).toLowerCase());
        }
        return out.toString();
    }
}

