/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.runtime;

import com.mucommander.commons.runtime.ComparableRuntimeProperty;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.RuntimeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaVersion
extends ComparableRuntimeProperty
implements JavaVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaVersion.class);
    private static JavaVersion currentValue;

    protected JavaVersion(String stringRepresentation, int intValue) {
        super(stringRepresentation, intValue);
    }

    public static void init() {
        if (currentValue == null) {
            currentValue = JavaVersion.parseSystemProperty(JavaVersion.getRawSystemProperty());
            LOGGER.info("Current Java version: {}", currentValue);
        }
    }

    public static JavaVersion getCurrent() {
        if (currentValue == null) {
            JavaVersion.init();
        }
        return currentValue;
    }

    public static String getRawSystemProperty() {
        return System.getProperty("java.version");
    }

    static JavaVersion parseSystemProperty(String javaVersionProp) {
        JavaVersion javaVersion = javaVersionProp == null || (javaVersionProp = javaVersionProp.trim()).equals("") ? JavaVersions.JAVA_1_5 : (javaVersionProp.startsWith("1.7") ? JavaVersions.JAVA_1_7 : (javaVersionProp.startsWith("1.6") ? JavaVersions.JAVA_1_6 : (javaVersionProp.startsWith("1.5") ? JavaVersions.JAVA_1_5 : (javaVersionProp.startsWith("1.4") ? JavaVersions.JAVA_1_4 : (javaVersionProp.startsWith("1.3") ? JavaVersions.JAVA_1_3 : (javaVersionProp.startsWith("1.2") ? JavaVersions.JAVA_1_2 : (javaVersionProp.startsWith("1.1") ? JavaVersions.JAVA_1_1 : (javaVersionProp.startsWith("1.0") ? JavaVersions.JAVA_1_0 : JavaVersions.JAVA_1_6))))))));
        return javaVersion;
    }

    protected RuntimeProperty getCurrentValue() {
        return JavaVersion.getCurrent();
    }
}

