/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.bom;

import com.mucommander.commons.io.bom.BOM;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class BOMWriter
extends OutputStreamWriter {
    protected OutputStream out;
    protected BOM bom;
    protected boolean bomWriteChecked;

    public BOMWriter(OutputStream out, BOM bom) throws UnsupportedEncodingException {
        this(out, bom.getEncoding(), bom);
    }

    public BOMWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        this(out, encoding, BOM.getInstance(encoding));
    }

    protected BOMWriter(OutputStream out, String encoding, BOM bom) throws UnsupportedEncodingException {
        super(out, encoding);
        this.out = out;
        this.bom = bom;
    }

    protected void checkWriteBOM() throws IOException {
        if (!this.bomWriteChecked) {
            if (this.bom != null) {
                this.out.write(this.bom.getSignature());
            }
            this.bomWriteChecked = true;
        }
    }

    public void write(int c) throws IOException {
        this.checkWriteBOM();
        super.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkWriteBOM();
        super.write(cbuf, off, len);
    }

    public void write(String str, int off, int len) throws IOException {
        this.checkWriteBOM();
        super.write(str, off, len);
    }
}

