/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.bom;

import com.mucommander.commons.io.bom.BOM;
import com.mucommander.commons.io.bom.BOMConstants;
import java.io.IOException;
import java.io.InputStream;

public class BOMInputStream
extends InputStream
implements BOMConstants {
    private InputStream in;
    private BOM bom;
    private byte[] leadingBytes;
    private int leadingBytesOff;
    private byte[] oneByteBuf;
    private static final int MAX_BOM_LENGTH;

    public BOMInputStream(InputStream in) throws IOException {
        int nbRead;
        this.in = in;
        byte[] bytes = new byte[MAX_BOM_LENGTH];
        int totalRead = 0;
        while ((nbRead = in.read(bytes, totalRead, MAX_BOM_LENGTH - totalRead)) != -1 && (totalRead += nbRead) < MAX_BOM_LENGTH) {
        }
        if (totalRead < MAX_BOM_LENGTH) {
            byte[] tempBytes = new byte[totalRead];
            System.arraycopy(bytes, 0, tempBytes, 0, totalRead);
            bytes = tempBytes;
        }
        int bestMatchLength = 0;
        int bestMatchIndex = -1;
        for (int i = 0; i < SUPPORTED_BOMS.length; ++i) {
            BOM tempBom = SUPPORTED_BOMS[i];
            byte[] tempBomSig = tempBom.getSignature();
            if (tempBomSig.length <= bestMatchLength || !BOMInputStream.startsWith(bytes, tempBomSig)) continue;
            bestMatchIndex = i;
            bestMatchLength = tempBomSig.length;
        }
        if (bestMatchIndex != -1) {
            this.bom = SUPPORTED_BOMS[bestMatchIndex];
            if (bestMatchLength < MAX_BOM_LENGTH) {
                this.leadingBytes = bytes;
                this.leadingBytesOff = bestMatchLength;
            }
        } else {
            this.leadingBytes = bytes;
            this.leadingBytesOff = 0;
        }
    }

    private static boolean startsWith(byte[] b1, byte[] b2) {
        int b1Len = b1.length;
        int b2Len = b2.length;
        if (b1Len < b2Len) {
            return false;
        }
        for (int i = 0; i < b2Len; ++i) {
            if (b2[i] == b1[i]) continue;
            return false;
        }
        return true;
    }

    public BOM getBOM() {
        return this.bom;
    }

    public int read() throws IOException {
        int ret;
        if (this.oneByteBuf == null) {
            this.oneByteBuf = new byte[1];
        }
        return (ret = this.read(this.oneByteBuf, 0, 1)) == -1 ? -1 : this.oneByteBuf[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.leadingBytes == null || this.leadingBytesOff >= this.leadingBytes.length) {
            return this.in.read(b, off, len);
        }
        int nbBytes = Math.min(this.leadingBytes.length - this.leadingBytesOff, len);
        System.arraycopy(this.leadingBytes, this.leadingBytesOff, b, off, nbBytes);
        this.leadingBytesOff += nbBytes;
        return nbBytes;
    }

    public void close() throws IOException {
        this.in.close();
    }

    static {
        int maxLen = SUPPORTED_BOMS[0].getSignature().length;
        for (int i = 1; i < SUPPORTED_BOMS.length; ++i) {
            int len = SUPPORTED_BOMS[i].getSignature().length;
            if (len <= maxLen) continue;
            maxLen = len;
        }
        MAX_BOM_LENGTH = maxLen;
    }
}

