/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.base64;

import com.mucommander.commons.io.base64.Base64Table;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private InputStream in;
    private final int[] decodingTable;
    private final byte paddingChar;
    private int[] readBuffer = new int[3];
    private int readOffset;
    private int bytesLeft;
    private int[] decodeBuffer = new int[4];

    public Base64InputStream(InputStream in, Base64Table table) {
        this.in = in;
        this.decodingTable = table.getDecodingTable();
        this.paddingChar = table.getPaddingChar();
    }

    public int read() throws IOException {
        if (this.bytesLeft == 0) {
            int nbRead = 0;
            while (nbRead < 4) {
                int read = this.in.read();
                if (read == -1) {
                    if (nbRead % 4 != 0) {
                        throw new IOException("InputStream did not end on a multiple of 4 bytes");
                    }
                    if (nbRead != 0) break;
                    return -1;
                }
                this.decodeBuffer[nbRead] = this.decodingTable[read];
                if (this.decodeBuffer[nbRead] == -1 && read != this.paddingChar) continue;
                ++nbRead;
            }
            this.readBuffer[this.bytesLeft++] = this.decodeBuffer[0] << 2 & 0xFC | this.decodeBuffer[1] >> 4 & 3;
            if (this.decodeBuffer[2] != -1) {
                this.readBuffer[this.bytesLeft++] = this.decodeBuffer[1] << 4 & 0xF0 | this.decodeBuffer[2] >> 2 & 0xF;
                if (this.decodeBuffer[3] != -1) {
                    this.readBuffer[this.bytesLeft++] = this.decodeBuffer[2] << 6 & 0xC0 | this.decodeBuffer[3] & 0x3F;
                }
            }
            this.readOffset = 0;
        }
        --this.bytesLeft;
        return this.readBuffer[this.readOffset++];
    }
}

