/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.base64;

import com.mucommander.commons.io.base64.Base64OutputStream;
import com.mucommander.commons.io.base64.Base64Table;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class Base64Encoder {
    public static String encode(byte[] b) {
        return Base64Encoder.encode(b, 0, b.length, Base64Table.STANDARD_TABLE);
    }

    public static String encode(byte[] b, Base64Table table) {
        return Base64Encoder.encode(b, 0, b.length, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(byte[] b, int off, int len, Base64Table table) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base64OutputStream out64 = new Base64OutputStream(bout, false, table);
        try {
            out64.write(b, off, len);
            out64.writePadding();
            String string = new String(bout.toByteArray());
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                out64.close();
            }
            catch (IOException e) {}
        }
    }

    public static String encode(String s) {
        try {
            return Base64Encoder.encode(s, "UTF-8", Base64Table.STANDARD_TABLE);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String encode(String s, String encoding, Base64Table table) throws UnsupportedEncodingException {
        return Base64Encoder.encode(s.getBytes(encoding), table);
    }
}

