/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.base64;

import com.mucommander.commons.io.base64.Base64InputStream;
import com.mucommander.commons.io.base64.Base64Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class Base64Decoder {
    public static byte[] decodeAsBytes(String s) throws IOException {
        return Base64Decoder.decodeAsBytes(s, Base64Table.STANDARD_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decodeAsBytes(String s, Base64Table table) throws IOException {
        byte[] b = s.getBytes();
        if (b.length % 4 != 0) {
            throw new IOException("Byte array length is not a multiple of 4");
        }
        Base64InputStream bin = new Base64InputStream(new ByteArrayInputStream(b), table);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int i;
            while ((i = bin.read()) != -1) {
                bout.write(i);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            bin.close();
        }
    }
}

