/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.FileTransferException;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    public static long copyStream(InputStream in, OutputStream out) throws FileTransferException {
        return StreamUtils.copyStream(in, out, BufferPool.getDefaultBufferSize());
    }

    public static long copyStream(InputStream in, OutputStream out, int bufferSize) throws FileTransferException {
        return StreamUtils.copyStream(in, out, bufferSize, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyStream(InputStream in, OutputStream out, int bufferSize, long length) throws FileTransferException {
        byte[] buffer = BufferPool.getByteArray(bufferSize);
        try {
            long l = StreamUtils.copyStream(in, out, buffer, length);
            return l;
        }
        finally {
            BufferPool.releaseByteArray(buffer);
        }
    }

    public static long copyStream(InputStream in, OutputStream out, byte[] buffer, long length) throws FileTransferException {
        long totalRead = 0L;
        while (length > 0L) {
            int nbRead;
            try {
                nbRead = in.read(buffer, 0, (int)Math.min((long)buffer.length, length));
            }
            catch (IOException e) {
                throw new FileTransferException(4);
            }
            if (nbRead == -1) break;
            try {
                out.write(buffer, 0, nbRead);
            }
            catch (IOException e) {
                throw new FileTransferException(5, totalRead);
            }
            length -= (long)nbRead;
            totalRead += (long)nbRead;
        }
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillWithConstant(OutputStream out, byte value, long len, int bufferSize) throws IOException {
        byte[] buffer = BufferPool.getByteArray(bufferSize);
        if (value != 0) {
            for (int i = 0; i < bufferSize; ++i) {
                buffer[i] = value;
            }
        }
        try {
            int nbWrite;
            for (long remaining = len; remaining > 0L; remaining -= (long)nbWrite) {
                nbWrite = (int)(remaining > (long)bufferSize ? (long)bufferSize : remaining);
                out.write(buffer, 0, nbWrite);
            }
        }
        finally {
            BufferPool.releaseByteArray(buffer);
        }
    }

    public static void copyChunk(RandomAccessInputStream rais, RandomAccessOutputStream raos, long srcOffset, long destOffset, long length) throws IOException {
        StreamUtils.copyChunk(rais, raos, srcOffset, destOffset, length, BufferPool.getDefaultBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyChunk(RandomAccessInputStream rais, RandomAccessOutputStream raos, long srcOffset, long destOffset, long length, int bufferSize) throws IOException {
        rais.seek(srcOffset);
        raos.seek(destOffset);
        byte[] buffer = BufferPool.getByteArray(bufferSize);
        try {
            int nbBytes;
            for (long remaining = length; remaining > 0L; remaining -= (long)nbBytes) {
                nbBytes = (int)(remaining < (long)bufferSize ? remaining : (long)bufferSize);
                rais.readFully(buffer, 0, nbBytes);
                raos.write(buffer, 0, nbBytes);
            }
        }
        finally {
            BufferPool.releaseByteArray(buffer);
        }
    }

    public static byte[] readFully(InputStream in, byte[] b) throws EOFException, IOException {
        return StreamUtils.readFully(in, b, 0, b.length);
    }

    public static byte[] readFully(InputStream in, byte[] b, int off, int len) throws EOFException, IOException {
        if (len > 0) {
            int nbRead;
            int totalRead = 0;
            do {
                if ((nbRead = in.read(b, off + totalRead, len - totalRead)) >= 0) continue;
                throw new EOFException();
            } while ((totalRead += nbRead) < len);
        }
        return b;
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        long nbSkipped;
        if (n <= 0L) {
            return;
        }
        do {
            if ((nbSkipped = in.skip(n)) >= 0L) continue;
            throw new EOFException();
        } while ((n -= nbSkipped) > 0L);
    }

    public static int readUpTo(InputStream in, byte[] b) throws IOException {
        return StreamUtils.readUpTo(in, b, 0, b.length);
    }

    public static int readUpTo(InputStream in, byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        if (len > 0) {
            int nbRead;
            while ((nbRead = in.read(b, off + totalRead, len - totalRead)) >= 0 && (totalRead += nbRead) < len) {
            }
        }
        return totalRead;
    }

    public static void readUntilEOF(InputStream in) throws IOException {
        StreamUtils.readUntilEOF(in, BufferPool.getDefaultBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readUntilEOF(InputStream in, int bufferSize) throws IOException {
        byte[] buffer = BufferPool.getByteArray(bufferSize);
        try {
            int nbRead;
            while ((nbRead = in.read(buffer, 0, buffer.length)) != -1) {
            }
        }
        finally {
            BufferPool.releaseByteArray(buffer);
        }
    }
}

