/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SilenceableOutputStream
extends FilterOutputStream {
    private boolean silenced;

    public SilenceableOutputStream(OutputStream out) {
        super(out);
    }

    public SilenceableOutputStream(OutputStream out, boolean silenced) {
        super(out);
        this.silenced = silenced;
    }

    public void setSilenced(boolean silenced) {
        this.silenced = silenced;
    }

    public void write(int b) throws IOException {
        if (this.silenced) {
            return;
        }
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (this.silenced) {
            return;
        }
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.silenced) {
            return;
        }
        this.out.write(b, off, len);
    }
}

