/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.RandomAccess;
import com.mucommander.commons.io.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RandomAccessInputStream
extends InputStream
implements RandomAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomAccessInputStream.class);
    private long markOffset;

    public void readFully(byte[] b) throws IOException {
        StreamUtils.readFully(this, b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        StreamUtils.readFully(this, b, off, len);
    }

    public long skip(long n) throws IOException {
        long length;
        if (n <= 0L) {
            return 0L;
        }
        long offset = this.getOffset();
        if (offset >= (length = this.getLength())) {
            return -1L;
        }
        long newOffset = offset + n;
        if (newOffset > length) {
            newOffset = length;
        }
        this.seek(newOffset);
        return (int)(newOffset - offset);
    }

    public int available() throws IOException {
        return (int)(this.getLength() - this.getOffset() - 1L);
    }

    public synchronized void mark(int readLimit) {
        try {
            this.markOffset = this.getOffset();
        }
        catch (IOException e) {
            LOGGER.info("Caught exception", e);
        }
    }

    public synchronized void reset() throws IOException {
        this.seek(this.markOffset);
    }

    public boolean markSupported() {
        return true;
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;
}

