/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.IOException;

public class BufferedRandomOutputStream
extends RandomAccessOutputStream {
    private RandomAccessOutputStream raos;
    private byte[] buffer;
    private int count;

    public BufferedRandomOutputStream(RandomAccessOutputStream raos) {
        this(raos, 65536);
    }

    public BufferedRandomOutputStream(RandomAccessOutputStream raos, int size) {
        this.raos = raos;
        this.buffer = BufferPool.getByteArray(size);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.raos.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.count++] = (byte)b;
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buffer.length) {
            this.flushBuffer();
            this.raos.write(b, off, len);
            return;
        }
        if (len > this.buffer.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.raos.flush();
    }

    public synchronized long getOffset() throws IOException {
        return this.raos.getOffset() + (long)this.count;
    }

    public synchronized void seek(long offset) throws IOException {
        this.flush();
        this.raos.seek(offset);
    }

    public synchronized long getLength() throws IOException {
        return Math.max(this.raos.getLength(), this.getOffset());
    }

    public synchronized void setLength(long newLength) throws IOException {
        this.flush();
        this.raos.setLength(newLength);
    }

    public synchronized void close() throws IOException {
        if (this.buffer != null) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BufferPool.releaseByteArray(this.buffer);
            this.buffer = null;
        }
        this.raos.close();
    }

    protected void finalize() throws Throwable {
        if (this.buffer != null) {
            BufferPool.releaseByteArray(this.buffer);
        }
        super.finalize();
    }
}

