/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import java.nio.ByteBuffer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferPool.class);
    private static Vector<BufferContainer> bufferContainers = new Vector();
    public static int defaultBufferSize = 65536;
    public static long maxPoolSize = 0xA00000L;
    public static long poolSize;

    public static synchronized byte[] getByteArray() {
        return BufferPool.getByteArray(BufferPool.getDefaultBufferSize());
    }

    public static synchronized byte[] getByteArray(int length) {
        return (byte[])BufferPool.getBuffer(new ByteArrayFactory(), length);
    }

    public static synchronized ByteBuffer getByteBuffer() {
        return BufferPool.getByteBuffer(BufferPool.getDefaultBufferSize());
    }

    public static synchronized ByteBuffer getByteBuffer(int capacity) {
        return (ByteBuffer)BufferPool.getBuffer(new ByteBufferFactory(), capacity);
    }

    public static synchronized Object getBuffer(BufferFactory factory, int size) {
        int nbBuffers = bufferContainers.size();
        for (int i = 0; i < nbBuffers; ++i) {
            BufferContainer bufferContainer = bufferContainers.elementAt(i);
            Object buffer = bufferContainer.getBuffer();
            if (bufferContainer.getLength() != size || !factory.matchesBufferClass(buffer.getClass())) continue;
            bufferContainers.removeElementAt(i);
            poolSize -= (long)bufferContainer.getSize();
            return buffer;
        }
        LOGGER.trace("Creating new buffer with {} size=", factory, size);
        return factory.newBuffer(size);
    }

    public static synchronized boolean releaseByteArray(byte[] buffer) {
        return BufferPool.releaseBuffer(buffer, new ByteArrayFactory());
    }

    public static synchronized boolean releaseByteBuffer(ByteBuffer buffer) {
        return BufferPool.releaseBuffer(buffer, new ByteBufferFactory());
    }

    public static synchronized boolean releaseBuffer(Object buffer, BufferFactory factory) {
        if (buffer == null) {
            throw new IllegalArgumentException("specified buffer is null");
        }
        BufferContainer bufferContainer = factory.newBufferContainer(buffer);
        if (bufferContainers.contains(bufferContainer)) {
            LOGGER.info("Warning: specified buffer is already in the pool: {}", buffer);
            return false;
        }
        long bufferSize = bufferContainer.getSize();
        if (maxPoolSize != -1L && poolSize + bufferSize > maxPoolSize) {
            LOGGER.info("Warning: maximum pool size reached, buffer not added to the pool: {}", buffer);
            return false;
        }
        bufferContainers.add(bufferContainer);
        poolSize += bufferSize;
        return true;
    }

    public static int getDefaultBufferSize() {
        return defaultBufferSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteBufferFactory
    extends BufferFactory {
        @Override
        public Object newBuffer(int size) {
            return ByteBuffer.allocateDirect(size);
        }

        @Override
        public BufferContainer newBufferContainer(Object buffer) {
            return new BufferContainer(buffer){

                protected int getLength() {
                    return ((ByteBuffer)this.buffer).capacity();
                }

                protected int getSize() {
                    return this.getLength();
                }
            };
        }

        @Override
        public Class<?> getBufferClass() {
            return ByteBuffer.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArrayFactory
    extends BufferFactory {
        @Override
        public Object newBuffer(int size) {
            return new byte[size];
        }

        @Override
        public BufferContainer newBufferContainer(Object buffer) {
            return new BufferContainer(buffer){

                protected int getLength() {
                    return ((byte[])this.buffer).length;
                }

                protected int getSize() {
                    return this.getLength();
                }
            };
        }

        @Override
        public Class<?> getBufferClass() {
            return byte[].class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BufferFactory {
        public boolean matchesBufferClass(Class<?> bufferClass) {
            return this.getBufferClass().isAssignableFrom(bufferClass);
        }

        public abstract Object newBuffer(int var1);

        public abstract BufferContainer newBufferContainer(Object var1);

        public abstract Class<?> getBufferClass();
    }

    public static abstract class BufferContainer {
        protected Object buffer;

        protected BufferContainer(Object buffer) {
            this.buffer = buffer;
        }

        protected Object getBuffer() {
            return this.buffer;
        }

        public boolean equals(Object o) {
            return o instanceof BufferContainer && this.buffer == ((BufferContainer)o).buffer;
        }

        protected abstract int getLength();

        protected abstract int getSize();
    }
}

