/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.StreamOutOfBoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private long totalRead;
    private long allowedBytes;
    private boolean throwStreamOutOfBoundException;

    public BoundedInputStream(InputStream in, long allowedBytes, boolean throwStreamOutOfBoundException) {
        super(in);
        this.allowedBytes = allowedBytes;
        this.throwStreamOutOfBoundException = throwStreamOutOfBoundException;
    }

    protected int handleStreamOutOfBound() throws StreamOutOfBoundException {
        if (this.throwStreamOutOfBoundException) {
            throw new StreamOutOfBoundException(this.allowedBytes);
        }
        return -1;
    }

    public synchronized long getRemainingBytes() {
        return this.allowedBytes <= -1L ? Long.MAX_VALUE : this.allowedBytes - this.totalRead;
    }

    public synchronized int read() throws IOException {
        if (this.getRemainingBytes() == 0L) {
            return this.handleStreamOutOfBound();
        }
        int i = this.in.read();
        ++this.totalRead;
        return i;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int canRead = (int)Math.min(this.getRemainingBytes(), (long)len);
        if (canRead == 0) {
            return this.handleStreamOutOfBound();
        }
        int nbRead = this.in.read(b, off, canRead);
        if (nbRead > 0) {
            this.totalRead += (long)nbRead;
        }
        return nbRead;
    }

    public synchronized long skip(long n) throws IOException {
        int canSkip = (int)Math.min(this.getRemainingBytes(), n);
        if (canSkip == 0) {
            return this.handleStreamOutOfBound();
        }
        long nbSkipped = this.in.skip(canSkip);
        if (nbSkipped > 0L) {
            this.totalRead += nbSkipped;
        }
        return nbSkipped;
    }

    public synchronized int available() throws IOException {
        return Math.min(this.in.available(), (int)this.getRemainingBytes());
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
    }
}

