/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.RandomAccessInputStream;
import java.io.IOException;

public abstract class BlockRandomInputStream
extends RandomAccessInputStream {
    protected final int blockSize;
    private final byte[] block;
    private int blockOff;
    private int blockLen;
    private long offset;

    protected BlockRandomInputStream(int blockSize) {
        this.blockSize = blockSize;
        this.block = new byte[blockSize];
    }

    private boolean eofReached() throws IOException {
        return this.offset >= this.getLength();
    }

    private void checkBuffer() throws IOException {
        if (this.blockOff >= this.blockLen) {
            this.readBlock();
        }
    }

    private void readBlock() throws IOException {
        int len = Math.min((int)(this.getLength() - this.offset), this.blockSize);
        len = this.readBlock(this.offset, this.block, len);
        this.blockOff = 0;
        this.blockLen = len;
    }

    public int read() throws IOException {
        if (this.eofReached()) {
            return -1;
        }
        this.checkBuffer();
        byte ret = this.block[this.blockOff];
        ++this.blockOff;
        ++this.offset;
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.eofReached()) {
            return -1;
        }
        this.checkBuffer();
        int nbBytes = Math.min(len, this.blockLen - this.blockOff);
        System.arraycopy(this.block, this.blockOff, b, off, nbBytes);
        this.blockOff += nbBytes;
        this.offset += (long)nbBytes;
        return nbBytes;
    }

    public long getOffset() throws IOException {
        return this.offset;
    }

    public void seek(long newOffset) throws IOException {
        if (newOffset >= this.offset && newOffset < this.offset + (long)this.blockLen) {
            this.blockOff += (int)(newOffset - this.offset);
            this.offset = newOffset;
        } else {
            this.offset = newOffset;
            this.readBlock();
        }
    }

    protected abstract int readBlock(long var1, byte[] var3, int var4) throws IOException;
}

