/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.zip.provider.DeflatedOutputStream;
import com.mucommander.commons.file.impl.zip.provider.ZipBuffer;
import com.mucommander.commons.file.impl.zip.provider.ZipConstants;
import com.mucommander.commons.file.impl.zip.provider.ZipEntry;
import com.mucommander.commons.file.impl.zip.provider.ZipEntryInfo;
import com.mucommander.commons.file.impl.zip.provider.ZipLong;
import com.mucommander.commons.file.impl.zip.provider.ZipOutputStream;
import com.mucommander.commons.file.impl.zip.provider.ZipShort;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.BufferedRandomOutputStream;
import com.mucommander.commons.io.EncodingDetector;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.commons.io.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFile.class);
    private AbstractFile file;
    private RandomAccessInputStream rais;
    private RandomAccessOutputStream raos;
    private Vector<ZipEntry> entries = new Vector();
    private Hashtable<String, ZipEntry> nameMap = new Hashtable();
    private String comment;
    private String defaultEncoding = null;
    private ZipBuffer zipBuffer = new ZipBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(AbstractFile f) throws IOException, ZipException, UnsupportedFileOperationException {
        this.file = f;
        try {
            this.openRead();
            this.parseCentralDirectory();
        }
        finally {
            this.closeRead();
        }
    }

    private void openRead() throws IOException, UnsupportedFileOperationException {
        if (this.rais != null) {
            LOGGER.info("Warning: an existing RandomAccessInputStream was found, closing it now");
            this.rais.close();
        }
        this.rais = this.file.getRandomAccessInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRead() throws IOException {
        if (this.rais != null) {
            try {
                this.rais.close();
            }
            finally {
                this.rais = null;
            }
        }
    }

    private void openWrite() throws IOException, UnsupportedFileOperationException {
        if (this.raos != null) {
            LOGGER.info("Warning: an existing RandomAccessOutputStream was found, closing it now");
            this.raos.close();
        }
        this.raos = new BufferedRandomOutputStream(this.file.getRandomAccessOutputStream(), 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWrite() throws IOException {
        if (this.raos != null) {
            try {
                this.raos.close();
            }
            finally {
                this.raos = null;
            }
        }
    }

    public Iterator<ZipEntry> getEntries() {
        return this.entries.iterator();
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException, ZipException, UnsupportedFileOperationException {
        ZipEntryInfo entryInfo = ze.getEntryInfo();
        if (entryInfo == null) {
            throw new ZipException("Unknown entry: " + ze.getName());
        }
        this.openRead();
        RandomAccessInputStream entryIn = this.rais;
        if (entryInfo.dataOffset == -1L) {
            this.calculateDataOffset(entryInfo);
        }
        this.rais = null;
        long start = entryInfo.dataOffset;
        BoundedInputStream bis = new BoundedInputStream(entryIn, start, ze.getCompressedSize());
        switch (ze.getMethod()) {
            case 0: {
                return bis;
            }
            case 8: {
                bis.addDummy();
                return new InflaterInputStream(bis, new Inflater(true));
            }
        }
        throw new ZipException("Found unsupported compression method " + ze.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(ZipEntry ze) throws IOException, ZipException, UnsupportedFileOperationException {
        this.openRead();
        this.openWrite();
        try {
            long cdEndOffset;
            long cdStartOffset;
            ZipEntryInfo entryInfo = ze.getEntryInfo();
            if (entryInfo == null) {
                if (ze.isDirectory()) {
                    return;
                }
                throw new ZipException("Unknown entry: " + ze.getName());
            }
            int entryIndex = this.entries.indexOf(ze);
            int nbEntries = this.entries.size();
            if (nbEntries == 1) {
                cdStartOffset = 0L;
                cdEndOffset = 0L;
                this.raos.seek(0L);
            } else {
                cdStartOffset = this.entries.elementAt((int)0).getEntryInfo().centralHeaderOffset;
                if (entryIndex == nbEntries - 1) {
                    ZipEntryInfo lastEntryInfo = this.entries.elementAt(nbEntries - 2).getEntryInfo();
                    long newCdStartOffset = entryInfo.headerOffset;
                    cdEndOffset = lastEntryInfo.centralHeaderOffset + lastEntryInfo.centralHeaderLen;
                    long cdLength = cdEndOffset - cdStartOffset;
                    StreamUtils.copyChunk(this.rais, this.raos, cdStartOffset, newCdStartOffset, cdLength);
                    long shift = cdStartOffset - newCdStartOffset;
                    for (int i = 0; i < nbEntries - 1; ++i) {
                        this.entries.elementAt((int)i).getEntryInfo().centralHeaderOffset -= shift;
                    }
                    cdStartOffset = newCdStartOffset;
                    cdEndOffset = newCdStartOffset + cdLength;
                } else {
                    if (entryInfo.dataOffset == -1L) {
                        this.calculateDataOffset(entryInfo);
                    }
                    this.raos.seek(entryInfo.headerOffset);
                    StreamUtils.fillWithConstant(this.raos, (byte)0, entryInfo.dataOffset - entryInfo.headerOffset + ze.getCompressedSize(), 65536);
                    ZipEntryInfo lastEntryInfo = this.entries.elementAt(nbEntries - 1).getEntryInfo();
                    long startOffset = this.entries.elementAt((int)(entryIndex + 1)).getEntryInfo().centralHeaderOffset;
                    cdEndOffset = lastEntryInfo.centralHeaderOffset + lastEntryInfo.centralHeaderLen;
                    StreamUtils.copyChunk(this.rais, this.raos, startOffset, entryInfo.centralHeaderOffset, cdEndOffset - startOffset);
                    long shift = entryInfo.centralHeaderLen;
                    for (int i = entryIndex + 1; i < nbEntries; ++i) {
                        this.entries.elementAt((int)i).getEntryInfo().centralHeaderOffset -= shift;
                    }
                    cdEndOffset -= shift;
                }
            }
            ZipOutputStream.writeCentralDirectoryEnd(this.raos, nbEntries - 1, cdEndOffset - cdStartOffset, cdStartOffset, this.comment, "UTF-8", this.zipBuffer);
            this.raos.setLength(this.raos.getOffset());
            this.entries.removeElementAt(entryIndex);
            this.nameMap.remove(ze.getName());
        }
        finally {
            try {
                this.closeRead();
            }
            catch (IOException e) {}
            try {
                this.closeWrite();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream addEntry(final ZipEntry entry) throws IOException, UnsupportedFileOperationException {
        try {
            this.openRead();
            this.openWrite();
            this.positionAtCentralDirectory();
            long centralDirectoryStart = this.rais.getOffset();
            this.raos.seek(centralDirectoryStart);
            ZipEntryInfo entryInfo = new ZipEntryInfo();
            entryInfo.encoding = "UTF-8";
            entryInfo.headerOffset = centralDirectoryStart;
            entryInfo.dataOffset = entryInfo.headerOffset + ZipOutputStream.writeLocalFileHeader(entry, this.raos, entryInfo.encoding, false, this.zipBuffer);
            entry.setEntryInfo(entryInfo);
            this.entries.add(entry);
            this.nameMap.put(entry.getName(), entry);
            final byte[] deflaterBuf = BufferPool.getByteArray(512);
            DeflatedOutputStream zeos = new DeflatedOutputStream(this.raos, new Deflater(-1, true), deflaterBuf){

                public void close() throws IOException {
                    ZipOutputStream.finalizeEntryData(entry, this, ZipFile.this.raos, false, ZipFile.this.zipBuffer);
                    int nbEntries = ZipFile.this.entries.size();
                    long cdLength = 0L;
                    long cdOffset = ZipFile.this.raos.getOffset();
                    for (int i = 0; i < nbEntries; ++i) {
                        ZipEntry tempZe = (ZipEntry)ZipFile.this.entries.elementAt(i);
                        ZipEntryInfo tempEntryInfo = tempZe.getEntryInfo();
                        tempEntryInfo.centralHeaderOffset = ZipFile.this.raos.getOffset();
                        cdLength += ZipOutputStream.writeCentralFileHeader(tempZe, ZipFile.this.raos, tempEntryInfo.encoding, tempEntryInfo.headerOffset, tempEntryInfo.hasDataDescriptor, ZipFile.this.zipBuffer);
                        tempEntryInfo.centralHeaderLen = ZipFile.this.raos.getOffset() - tempEntryInfo.centralHeaderOffset;
                    }
                    ZipOutputStream.writeCentralDirectoryEnd(ZipFile.this.raos, nbEntries, cdLength, cdOffset, ZipFile.this.comment, "UTF-8", ZipFile.this.zipBuffer);
                    ZipFile.this.raos.setLength(ZipFile.this.raos.getOffset());
                    BufferPool.releaseByteArray(deflaterBuf);
                    super.close();
                    ZipFile.this.closeWrite();
                }
            };
            if (entry.isDirectory()) {
                ((OutputStream)zeos).close();
                OutputStream outputStream = null;
                return outputStream;
            }
            DeflatedOutputStream deflatedOutputStream = zeos;
            return deflatedOutputStream;
        }
        finally {
            this.closeRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(ZipEntry entry) throws IOException, UnsupportedFileOperationException {
        try {
            this.openWrite();
            ZipEntryInfo entryInfo = entry.getEntryInfo();
            this.raos.seek(entryInfo.headerOffset + 10L);
            this.raos.write(ZipLong.getBytes(entry.getDosTime(), this.zipBuffer.longBuffer));
            this.raos.seek(entryInfo.centralHeaderOffset + 4L);
            ZipOutputStream.writeVersionMadeBy(entry, this.raos, this.zipBuffer);
            this.raos.seek(entryInfo.centralHeaderOffset + 12L);
            this.raos.write(ZipLong.getBytes(entry.getDosTime(), this.zipBuffer.longBuffer));
            this.raos.seek(entryInfo.centralHeaderOffset + 38L);
            this.raos.write(ZipLong.getBytes(entry.getExternalAttributes(), this.zipBuffer.longBuffer));
        }
        finally {
            this.closeWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defragment() throws IOException, UnsupportedFileOperationException {
        int nbEntries = this.entries.size();
        if (nbEntries == 0) {
            return;
        }
        try {
            this.openRead();
            this.openWrite();
            long shift = 0L;
            ZipEntry currentEntry = this.entries.elementAt(0);
            ZipEntryInfo currentEntryInfo = currentEntry.getEntryInfo();
            if (currentEntryInfo.dataOffset == -1L) {
                this.calculateDataOffset(currentEntryInfo);
            }
            if (currentEntryInfo.headerOffset > 0L) {
                StreamUtils.copyChunk(this.rais, this.raos, currentEntryInfo.headerOffset, 0L, currentEntryInfo.dataOffset - currentEntryInfo.headerOffset + currentEntry.getCompressedSize());
                shift = currentEntryInfo.headerOffset;
                currentEntryInfo.headerOffset = 0L;
                currentEntryInfo.dataOffset -= shift;
            }
            ZipEntry previousEntry = currentEntry;
            ZipEntryInfo previousEntryInfo = currentEntryInfo;
            for (int i = 1; i < nbEntries; ++i) {
                currentEntry = this.entries.elementAt(i);
                currentEntryInfo = currentEntry.getEntryInfo();
                if (currentEntryInfo.dataOffset == -1L) {
                    this.calculateDataOffset(currentEntryInfo);
                }
                long previousCompressedSize = previousEntry.getCompressedSize();
                long previousEntryEnd = previousEntryInfo.dataOffset + previousCompressedSize;
                if (previousEntryInfo.hasDataDescriptor) {
                    previousEntryEnd += 16L;
                }
                if (previousEntryEnd < currentEntryInfo.headerOffset) {
                    StreamUtils.copyChunk(this.rais, this.raos, currentEntryInfo.headerOffset, previousEntryInfo.dataOffset + previousCompressedSize, currentEntryInfo.dataOffset - currentEntryInfo.headerOffset + currentEntry.getCompressedSize());
                    shift = currentEntryInfo.headerOffset - (previousEntryInfo.dataOffset + previousCompressedSize);
                    currentEntryInfo.headerOffset -= shift;
                    currentEntryInfo.dataOffset -= shift;
                }
                previousEntry = currentEntry;
                previousEntryInfo = currentEntryInfo;
            }
            if (shift != 0L) {
                long cdLength = 0L;
                long cdOffset = this.raos.getOffset();
                for (int i = 0; i < nbEntries; ++i) {
                    ZipEntry ze = this.entries.elementAt(i);
                    ZipEntryInfo entryInfo = ze.getEntryInfo();
                    entryInfo.centralHeaderOffset = this.raos.getOffset();
                    cdLength += ZipOutputStream.writeCentralFileHeader(ze, this.raos, entryInfo.encoding, entryInfo.headerOffset, entryInfo.hasDataDescriptor, this.zipBuffer);
                    entryInfo.centralHeaderLen = this.raos.getOffset() - entryInfo.centralHeaderOffset;
                }
                ZipOutputStream.writeCentralDirectoryEnd(this.raos, nbEntries, cdLength, cdOffset, this.comment, "UTF-8", this.zipBuffer);
                this.raos.setLength(this.raos.getOffset());
            }
        }
        finally {
            try {
                this.closeRead();
            }
            catch (IOException e) {}
            try {
                this.closeWrite();
            }
            catch (IOException iOException) {}
        }
    }

    private void calculateDataOffset(ZipEntryInfo entryInfo) throws IOException {
        long dataOffset = entryInfo.headerOffset + 26L;
        this.rais.seek(dataOffset);
        byte[] b = new byte[2];
        this.rais.readFully(b);
        dataOffset += (long)(2 + ZipShort.getValue(b));
        this.rais.readFully(b);
        entryInfo.dataOffset = dataOffset += (long)(2 + ZipShort.getValue(b));
    }

    private void parseCentralDirectory() throws IOException, ZipException {
        ByteArrayOutputStream encodingAccumulator;
        this.positionAtCentralDirectory();
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.rais.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(CFH_SIG);
        boolean defaultEncodingSet = this.defaultEncoding != null;
        ByteArrayOutputStream byteArrayOutputStream = encodingAccumulator = defaultEncodingSet ? null : new ByteArrayOutputStream();
        while (sig == cfhSig) {
            boolean isUTF8;
            ZipEntryInfo entryInfo = new ZipEntryInfo();
            entryInfo.centralHeaderOffset = this.rais.getOffset() - 4L;
            this.rais.readFully(cfh);
            ZipEntry ze = new ZipEntry();
            int versionMadeBy = ZipShort.getValue(cfh, 0);
            ze.setPlatform(versionMadeBy >> 8 & 0xF);
            int gp = ZipShort.getValue(cfh, 4);
            boolean bl = isUTF8 = (gp & 0x800) != 0;
            if (isUTF8) {
                entryInfo.encoding = "UTF-8";
                LOGGER.info("Entry declared as UTF-8");
            } else if (defaultEncodingSet) {
                entryInfo.encoding = this.defaultEncoding;
                LOGGER.info("Using default encoding: " + this.defaultEncoding);
            }
            entryInfo.hasDataDescriptor = (gp & 8) != 0;
            int method = ZipShort.getValue(cfh, 6);
            if (method != 8 && method != 0) {
                throw new ZipException("Unsupported compression method");
            }
            ze.setMethod(method);
            ze.setDosTime(ZipLong.getValue(cfh, 8));
            ze.setCrc(ZipLong.getValue(cfh, 12));
            ze.setCompressedSize(ZipLong.getValue(cfh, 16));
            ze.setSize(ZipLong.getValue(cfh, 20));
            int fileNameLen = ZipShort.getValue(cfh, 24);
            int extraLen = ZipShort.getValue(cfh, 26);
            int commentLen = ZipShort.getValue(cfh, 28);
            ze.setInternalAttributes(ZipShort.getValue(cfh, 32));
            ze.setExternalAttributes(ZipLong.getValue(cfh, 34));
            byte[] filename = new byte[fileNameLen];
            this.rais.readFully(filename);
            if (entryInfo.encoding != null) {
                ZipFile.setFilename(ze, ZipFile.getString(filename, entryInfo.encoding));
            } else {
                entryInfo.filename = filename;
                ZipFile.feedEncodingAccumulator(encodingAccumulator, filename);
            }
            entryInfo.headerOffset = ZipLong.getValue(cfh, 38);
            byte[] extra = new byte[extraLen];
            this.rais.readFully(extra);
            ze.setExtra(extra);
            byte[] comment = new byte[commentLen];
            this.rais.readFully(comment);
            if (entryInfo.encoding != null) {
                ze.setComment(ZipFile.getString(comment, entryInfo.encoding));
            } else {
                entryInfo.comment = comment;
                ZipFile.feedEncodingAccumulator(encodingAccumulator, comment);
            }
            entryInfo.centralHeaderLen = 46 + fileNameLen + extraLen + commentLen;
            ze.setEntryInfo(entryInfo);
            this.entries.add(ze);
            this.nameMap.put(ze.getName(), ze);
            this.rais.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
        }
        if (encodingAccumulator != null && encodingAccumulator.size() > 0) {
            int nbEntries = this.entries.size();
            String guessedEncoding = EncodingDetector.detectEncoding(encodingAccumulator.toByteArray());
            LOGGER.info("Guessed encoding: " + guessedEncoding);
            for (int i = 0; i < nbEntries; ++i) {
                ZipEntry entry = this.entries.elementAt(i);
                ZipEntryInfo entryInfo = entry.getEntryInfo();
                if (entryInfo.encoding != null) continue;
                entryInfo.encoding = guessedEncoding;
                ZipFile.setFilename(entry, ZipFile.getString(entryInfo.filename, guessedEncoding));
                entryInfo.filename = null;
                entry.setComment(ZipFile.getString(entryInfo.comment, guessedEncoding));
                entryInfo.comment = null;
            }
        }
    }

    private static void setFilename(ZipEntry ze, String filename) {
        if (ze.getPlatform() == 0) {
            filename = filename.replace('\\', '/');
        }
        ze.setName(filename);
    }

    private static void feedEncodingAccumulator(ByteArrayOutputStream encodingAccumulator, byte[] bytes) throws IOException {
        if (encodingAccumulator.size() < 4096) {
            encodingAccumulator.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void positionAtCentralDirectory() throws IOException, ZipException {
        long length = this.rais.getLength();
        if (length < 22L) {
            throw new ZipException("Invalid Zip file (too small)");
        }
        byte[] buf = BufferPool.getByteArray(65557);
        try {
            int bufLen = (int)Math.min(length, 65557L);
            this.rais.seek(length - (long)bufLen);
            StreamUtils.readFully(this.rais, buf, 0, bufLen);
            boolean signatureFound = false;
            for (int off = bufLen - 22; off >= 0; --off) {
                if (buf[off] != EOCD_SIG[0] || buf[off + 1] != EOCD_SIG[1] || buf[off + 2] != EOCD_SIG[2] || buf[off + 3] != EOCD_SIG[3]) continue;
                signatureFound = true;
                break;
            }
            if (!signatureFound) {
                throw new ZipException("Invalid Zip stream (EOCD signature not found)");
            }
            byte[] cdStart = new byte[4];
            System.arraycopy(buf, off += 16, cdStart, 0, 4);
            byte[] commentLen = new byte[2];
            System.arraycopy(buf, off += 4, commentLen, 0, 2);
            byte[] commentBytes = new byte[ZipShort.getValue(commentLen)];
            System.arraycopy(buf, off += 2, commentBytes, 0, commentBytes.length);
            this.comment = ZipFile.getString(commentBytes, this.defaultEncoding != null ? this.defaultEncoding : EncodingDetector.detectEncoding(commentBytes));
            this.rais.seek(ZipLong.getValue(cdStart));
        }
        finally {
            BufferPool.releaseByteArray(buf);
        }
    }

    private static String getString(byte[] bytes, String encoding) {
        if (bytes.length == 0) {
            return "";
        }
        if (encoding != null) {
            try {
                return new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.info("Error: unsupported encoding: {}, falling back to default encoding", encoding);
            }
        }
        return new String(bytes);
    }

    private static class BoundedInputStream
    extends InputStream {
        private final RandomAccessInputStream rais;
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(RandomAccessInputStream rais, long start, long remaining) {
            this.rais = rais;
            this.remaining = remaining;
            this.loc = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessInputStream randomAccessInputStream = this.rais;
            synchronized (randomAccessInputStream) {
                this.rais.seek(this.loc++);
                return this.rais.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            int ret;
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            RandomAccessInputStream randomAccessInputStream = this.rais;
            synchronized (randomAccessInputStream) {
                this.rais.seek(this.loc);
                ret = this.rais.read(b, off, len);
            }
            if (ret > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        public void close() throws IOException {
            this.rais.close();
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }
}

