/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public abstract class ZipEntryOutputStream
extends OutputStream {
    protected OutputStream out;
    protected int method;
    protected CRC32 crc = new CRC32();

    public ZipEntryOutputStream(OutputStream out, int method) {
        this.out = out;
        this.method = method;
    }

    public long getCrc() {
        return this.crc.getValue();
    }

    public void write(int b) throws IOException {
        byte[] array = new byte[]{(byte)(b & 0xFF)};
        this.write(array, 0, 1);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public abstract int getTotalIn();

    public abstract int getTotalOut();
}

