/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip;

import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.impl.zip.ZipArchiveFile;
import com.mucommander.commons.file.impl.zip.provider.ZipEntry;
import java.io.IOException;
import java.util.zip.ZipInputStream;

public class JavaUtilZipEntryIterator
implements ArchiveEntryIterator {
    private ZipInputStream zin;
    private ArchiveEntry currentEntry;

    JavaUtilZipEntryIterator(ZipInputStream zin) throws IOException {
        this.zin = zin;
    }

    ZipInputStream getZipInputStream() {
        return this.zin;
    }

    ArchiveEntry getCurrentEntry() {
        return this.currentEntry;
    }

    private ArchiveEntry getNextEntry() throws IOException {
        try {
            java.util.zip.ZipEntry entry = this.zin.getNextEntry();
            if (entry == null) {
                return null;
            }
            return ZipArchiveFile.createArchiveEntry(new ZipEntry(entry));
        }
        catch (Exception e) {
            throw new IOException();
        }
        catch (Error e) {
            throw new IOException();
        }
    }

    public ArchiveEntry nextEntry() throws IOException {
        this.currentEntry = this.getNextEntry();
        return this.currentEntry;
    }

    public void close() throws IOException {
        this.zin.close();
    }
}

