/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.tar.provider;

import com.mucommander.commons.file.impl.tar.provider.TarBuffer;
import com.mucommander.commons.file.impl.tar.provider.TarEntry;
import com.mucommander.commons.io.BufferPool;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class TarInputStream
extends InputStream {
    protected boolean debug;
    protected boolean hasHitEOF;
    protected long entrySize;
    protected long entryOffset;
    protected byte[] recordBuf;
    protected byte[] nameBuf;
    protected int recordBufPos;
    protected int recordBufLeft;
    protected TarBuffer buffer;
    protected TarEntry currEntry;
    protected boolean closed;
    protected byte[] oneBuf;

    public TarInputStream(InputStream is, long entryOffset) throws IOException {
        this(is, 10240, 512, entryOffset);
    }

    public TarInputStream(InputStream is, int blockSize, int recordSize, long entryOffset) throws IOException {
        this.buffer = new TarBuffer(is, blockSize, recordSize);
        this.recordBuf = BufferPool.getByteArray(this.buffer.getRecordSize());
        this.nameBuf = BufferPool.getByteArray(256);
        this.oneBuf = BufferPool.getByteArray(1);
        this.debug = false;
        this.hasHitEOF = false;
        if (entryOffset > 0L) {
            if (entryOffset % (long)recordSize != 0L) {
                throw new IllegalArgumentException("entryOffset (" + entryOffset + ") is not a multiple of recordSize (" + recordSize + ")");
            }
            this.skipBytes(entryOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.buffer.close();
            }
            finally {
                BufferPool.releaseByteArray(this.recordBuf);
                BufferPool.releaseByteArray(this.nameBuf);
                BufferPool.releaseByteArray(this.oneBuf);
                this.closed = true;
            }
        }
    }

    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int markLimit) {
    }

    public void reset() {
    }

    public boolean readRecord() throws IOException {
        boolean ret = this.buffer.readRecord(this.recordBuf);
        this.recordBufPos = 0;
        this.recordBufLeft = ret ? this.recordBuf.length : 0;
        return ret;
    }

    public TarEntry getNextEntry() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long numToSkip = this.entrySize - this.entryOffset;
            if (this.debug) {
                System.err.println("TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + numToSkip + " bytes");
            }
            if (numToSkip > 0L) {
                this.skipBytes(numToSkip);
            }
        }
        if (!this.readRecord()) {
            if (this.debug) {
                System.err.println("READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(this.recordBuf)) {
            if (this.debug) {
                System.err.println("READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(this.recordBuf);
            this.currEntry.setOffset(this.buffer.getCurrentBlockNum() * this.buffer.getBlockSize() + this.buffer.getCurrentRecordNum() * this.buffer.getRecordSize());
            if (this.debug) {
                System.err.println("TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize());
            }
            this.entryOffset = 0L;
            this.entrySize = this.currEntry.getSize();
            this.recordBufPos = 0;
            this.recordBufLeft = 0;
        }
        if (this.currEntry != null && this.currEntry.isGNULongNameEntry()) {
            int length;
            StringBuffer longName = new StringBuffer();
            while ((length = this.read(this.nameBuf)) >= 0) {
                longName.append(new String(this.nameBuf, 0, length));
            }
            this.getNextEntry();
            if (this.currEntry == null) {
                return null;
            }
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.currEntry.setName(longName.toString());
        }
        return this.currEntry;
    }

    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        return num == -1 ? -1 : this.oneBuf[0] & 0xFF;
    }

    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        while (numToRead > 0) {
            if (this.recordBufLeft <= 0 && !this.readRecord()) {
                throw new EOFException("unexpected EOF with " + numToRead + " bytes unread");
            }
            int sz = numToRead > this.recordBufLeft ? this.recordBufLeft : numToRead;
            System.arraycopy(this.recordBuf, this.recordBufPos, buf, offset, sz);
            this.recordBufPos += sz;
            this.recordBufLeft -= sz;
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
            this.entryOffset += (long)sz;
        }
        return totalRead;
    }

    public long skip(long numToSkip) throws IOException {
        if (this.entryOffset >= this.entrySize) {
            return -1L;
        }
        if (numToSkip + this.entryOffset > this.entrySize) {
            numToSkip = (int)(this.entrySize - this.entryOffset);
        }
        return this.skipBytes(numToSkip);
    }

    private long skipBytes(long numToSkip) throws IOException {
        int totalSkipped = 0;
        int recordSize = this.buffer.getRecordSize();
        int blockSize = this.buffer.getBlockSize();
        while (numToSkip > 0L) {
            if (this.recordBufLeft > 0) {
                int sz = numToSkip > (long)this.recordBufLeft ? this.recordBufLeft : (int)numToSkip;
                this.recordBufPos += sz;
                this.recordBufLeft -= sz;
                totalSkipped += sz;
                numToSkip -= (long)sz;
                this.entryOffset += (long)sz;
                continue;
            }
            if (numToSkip >= (long)blockSize && this.buffer.getCurrentRecordNum() == this.buffer.getRecordsPerBlock() - 1) {
                if (!this.buffer.skipBlock()) {
                    throw new EOFException("unexpected EOF with " + numToSkip + " bytes unskipped");
                }
                totalSkipped += blockSize;
                numToSkip -= (long)blockSize;
                this.entryOffset += (long)blockSize;
                continue;
            }
            if (numToSkip >= (long)recordSize) {
                if (!this.buffer.skipRecord()) {
                    throw new EOFException("unexpected EOF with " + numToSkip + " bytes unskipped");
                }
                totalSkipped += recordSize;
                numToSkip -= (long)recordSize;
                this.entryOffset += (long)recordSize;
                continue;
            }
            if (this.readRecord()) continue;
            throw new EOFException("unexpected EOF with " + numToSkip + " bytes unskipped");
        }
        return totalSkipped;
    }
}

