/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.tar;

import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.impl.tar.provider.TarEntry;
import com.mucommander.commons.file.impl.tar.provider.TarInputStream;
import java.io.IOException;

class TarEntryIterator
implements ArchiveEntryIterator {
    private TarInputStream tin;
    private ArchiveEntry currentEntry;

    TarEntryIterator(TarInputStream tin) throws IOException {
        this.tin = tin;
    }

    TarInputStream getTarInputStream() {
        return this.tin;
    }

    ArchiveEntry getCurrentEntry() {
        return this.currentEntry;
    }

    private ArchiveEntry createArchiveEntry(TarEntry tarEntry) {
        ArchiveEntry entry = new ArchiveEntry(tarEntry.getName(), tarEntry.isDirectory(), tarEntry.getModTime().getTime(), tarEntry.getSize(), true);
        entry.setPermissions(new SimpleFilePermissions(tarEntry.getMode() & 0x1FF));
        entry.setOwner(tarEntry.getUserName());
        entry.setGroup(tarEntry.getGroupName());
        entry.setEntryObject(tarEntry);
        return entry;
    }

    private ArchiveEntry getNextEntry() throws IOException {
        TarEntry entry = this.tin.getNextEntry();
        if (entry == null) {
            return null;
        }
        return this.createArchiveEntry(entry);
    }

    public ArchiveEntry nextEntry() throws IOException {
        this.currentEntry = this.getNextEntry();
        return this.currentEntry;
    }

    public void close() throws IOException {
        this.tin.close();
    }
}

