/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.tar;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractROArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.tar.TarEntryIterator;
import com.mucommander.commons.file.impl.tar.provider.TarEntry;
import com.mucommander.commons.file.impl.tar.provider.TarInputStream;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.commons.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarArchiveFile
extends AbstractROArchiveFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarArchiveFile.class);

    public TarArchiveFile(AbstractFile file) {
        super(file);
    }

    private TarInputStream createTarStream(long entryOffset) throws IOException, UnsupportedFileOperationException {
        InputStream in = this.file.getInputStream();
        String name = this.getName();
        if (StringUtils.endsWithIgnoreCase(name, "tgz") || StringUtils.endsWithIgnoreCase(name, "tar.gz")) {
            in = new GZIPInputStream(in);
        } else if (StringUtils.endsWithIgnoreCase(name, "tbz2") || StringUtils.endsWithIgnoreCase(name, "tar.bz2")) {
            try {
                StreamUtils.skipFully(in, 2L);
                in = new CBZip2InputStream(new BufferedInputStream(in));
            }
            catch (Exception e) {
                LOGGER.info("Exception caught while creating CBZip2InputStream, throwing IOException", e);
                throw new IOException();
            }
        }
        return new TarInputStream(in, entryOffset);
    }

    public ArchiveEntryIterator getEntryIterator() throws IOException, UnsupportedFileOperationException {
        return new TarEntryIterator(this.createTarStream(0L));
    }

    public InputStream getEntryInputStream(ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException, UnsupportedFileOperationException {
        ArchiveEntry currentEntry;
        if (entry.isDirectory()) {
            throw new IOException();
        }
        if (entryIterator != null && entryIterator instanceof TarEntryIterator && (currentEntry = ((TarEntryIterator)entryIterator).getCurrentEntry()).getPath().equals(entry.getPath())) {
            return new FilterInputStream(((TarEntryIterator)entryIterator).getTarInputStream()){

                public void close() throws IOException {
                }
            };
        }
        TarEntry tarEntry = (TarEntry)entry.getEntryObject();
        if (tarEntry != null) {
            TarInputStream tin = this.createTarStream(tarEntry.getOffset());
            tin.getNextEntry();
            return tin;
        }
        throw new IOException("Unknown TAR entry: " + entry.getName());
    }
}

