/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sftp;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.SyncedFileAttributes;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.connection.ConnectionHandler;
import com.mucommander.commons.file.connection.ConnectionPool;
import com.mucommander.commons.file.impl.sftp.SFTPConnectionHandler;
import com.mucommander.commons.file.impl.sftp.SFTPConnectionHandlerFactory;
import com.mucommander.commons.io.ByteCounter;
import com.mucommander.commons.io.ByteUtils;
import com.mucommander.commons.io.CounterOutputStream;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPFile
extends ProtocolFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFTPFile.class);
    private String absPath;
    private SFTPFileAttributes fileAttributes;
    private AbstractFile parent;
    private boolean parentValSet;
    private String canonicalPath;
    private long canonicalPathFetchedTime;
    private static long attributeCachingPeriod = 60000L;
    private static final SFTPConnectionHandlerFactory connHandlerFactory = new SFTPConnectionHandlerFactory();

    protected SFTPFile(FileURL fileURL) throws IOException {
        this(fileURL, null);
    }

    protected SFTPFile(FileURL fileURL, SFTPFileAttributes fileAttributes) throws IOException {
        super(fileURL);
        this.absPath = fileURL.getPath();
        this.fileAttributes = fileAttributes == null ? new SFTPFileAttributes(fileURL) : fileAttributes;
    }

    private OutputStream getOutputStream(boolean append) throws IOException {
        final SFTPConnectionHandler connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
        try {
            SftpFile sftpFile;
            connHandler.checkConnection();
            if (this.exists()) {
                sftpFile = connHandler.sftpSubsystem.openFile(this.absPath, append ? 6 : 18);
                if (!append) {
                    this.fileAttributes.setSize(0L);
                }
            } else {
                FileAttributes atts = new FileAttributes();
                atts.setPermissions(new UnsignedInteger32(420L));
                sftpFile = connHandler.sftpSubsystem.openFile(this.absPath, 10, atts);
                this.fileAttributes.setExists(true);
                this.fileAttributes.setDate(System.currentTimeMillis());
                this.fileAttributes.setSize(0L);
            }
            return new CounterOutputStream(new SftpFileOutputStream(sftpFile, append ? this.getSize() : 0L){

                public void close() throws IOException {
                    super.close();
                    connHandler.releaseLock();
                }
            }, new ByteCounter(){

                public synchronized void add(long nbBytes) {
                    SFTPFile.this.fileAttributes.addToSize(nbBytes);
                    SFTPFile.this.fileAttributes.setDate(System.currentTimeMillis());
                }
            });
        }
        catch (IOException e) {
            connHandler.releaseLock();
            throw e;
        }
    }

    public boolean isSymlink() {
        return this.fileAttributes.isSymlink();
    }

    public long getDate() {
        return ((SFTPFileAttributes)this.getCanonicalFile().getUnderlyingFileObject()).getDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDate(long lastModified) throws IOException, UnsupportedFileOperationException {
        SFTPConnectionHandler connHandler = null;
        SftpFile sftpFile = null;
        try {
            connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
            connHandler.checkConnection();
            sftpFile = connHandler.sftpSubsystem.openFile(this.absPath, 2);
            FileAttributes attributes = sftpFile.getAttributes();
            attributes.setTimes(attributes.getAccessedTime(), new UnsignedInteger32(lastModified / 1000L));
            connHandler.sftpSubsystem.setAttributes(sftpFile, attributes);
            this.fileAttributes.setDate(lastModified);
        }
        finally {
            if (sftpFile != null) {
                try {
                    sftpFile.close();
                }
                catch (IOException e) {}
            }
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    public long getSize() {
        return ((SFTPFileAttributes)this.getCanonicalFile().getUnderlyingFileObject()).getSize();
    }

    public AbstractFile getParent() {
        if (!this.parentValSet) {
            FileURL parentFileURL = this.fileURL.getParent();
            if (parentFileURL != null) {
                this.parent = FileFactory.getFile(parentFileURL);
            }
            this.parentValSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValSet = true;
    }

    public boolean exists() {
        return this.fileAttributes.exists();
    }

    public FilePermissions getPermissions() {
        return ((SFTPFileAttributes)this.getCanonicalFile().getUnderlyingFileObject()).getPermissions();
    }

    public PermissionBits getChangeablePermissions() {
        return PermissionBits.FULL_PERMISSION_BITS;
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException {
        this.changePermissions(ByteUtils.setBit(this.getPermissions().getIntValue(), permission << access * 3, enabled));
    }

    public String getOwner() {
        return this.fileAttributes.getOwner();
    }

    public boolean canGetOwner() {
        return true;
    }

    public String getGroup() {
        return this.fileAttributes.getGroup();
    }

    public boolean canGetGroup() {
        return true;
    }

    public boolean isDirectory() {
        return ((SFTPFileAttributes)this.getCanonicalFile().getUnderlyingFileObject()).isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(0L);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public OutputStream getAppendOutputStream() throws IOException {
        return this.getOutputStream(true);
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        return new SFTPRandomAccessInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        ConnectionHandler connHandler = null;
        try {
            connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
            connHandler.checkConnection();
            if (this.isDirectory()) {
                ((SFTPConnectionHandler)connHandler).sftpSubsystem.removeDirectory(this.absPath);
            } else {
                ((SFTPConnectionHandler)connHandler).sftpSubsystem.removeFile(this.absPath);
            }
            this.fileAttributes.setExists(false);
            this.fileAttributes.setDirectory(false);
            this.fileAttributes.setSymlink(false);
            this.fileAttributes.setSize(0L);
        }
        finally {
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile[] ls() throws IOException {
        List files;
        SFTPConnectionHandler connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
        try {
            connHandler.checkConnection();
            files = connHandler.sftpClient.ls(this.absPath);
        }
        finally {
            connHandler.releaseLock();
        }
        int nbFiles = files.size();
        if (nbFiles == 0) {
            return new AbstractFile[0];
        }
        AbstractFile[] children = new AbstractFile[nbFiles];
        int fileCount = 0;
        String parentPath = this.fileURL.getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        for (SftpFile file : files) {
            String filename = file.getFilename();
            if (filename.equals(".") || filename.equals("..")) continue;
            FileURL childURL = (FileURL)this.fileURL.clone();
            childURL.setPath(parentPath + filename);
            children[fileCount++] = FileFactory.getFile(childURL, (AbstractFile)this, new SFTPFileAttributes(childURL, file.getAttributes()));
        }
        if (fileCount < nbFiles) {
            AbstractFile[] newChildren = new AbstractFile[fileCount];
            System.arraycopy(children, 0, newChildren, 0, fileCount);
            return newChildren;
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir() throws IOException {
        SFTPConnectionHandler connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
        try {
            connHandler.checkConnection();
            connHandler.sftpSubsystem.makeDirectory(this.absPath);
            this.fileAttributes.setExists(true);
            this.fileAttributes.setDirectory(true);
            this.fileAttributes.setDate(System.currentTimeMillis());
            this.fileAttributes.setSize(0L);
        }
        finally {
            connHandler.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTo(AbstractFile destFile) throws IOException {
        this.checkRenamePrerequisites(destFile, true, false);
        ConnectionHandler connHandler = null;
        try {
            connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
            connHandler.checkConnection();
            if (destFile.exists()) {
                destFile.delete();
            }
            ((SFTPConnectionHandler)connHandler).sftpClient.rename(this.absPath, destFile.getURL().getPath());
            ((SFTPFileAttributes)destFile.getUnderlyingFileObject()).fetchAttributes();
            this.fileAttributes.setExists(false);
            this.fileAttributes.setDirectory(false);
            this.fileAttributes.setSize(0L);
        }
        finally {
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    public Object getUnderlyingFileObject() {
        return this.fileAttributes;
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public long getFreeSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_FREE_SPACE);
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePermissions(int permissions) throws IOException {
        ConnectionHandler connHandler = null;
        try {
            connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
            connHandler.checkConnection();
            ((SFTPConnectionHandler)connHandler).sftpSubsystem.changePermissions(this.absPath, permissions);
            this.fileAttributes.setPermissions(new SimpleFilePermissions(permissions));
        }
        finally {
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    public InputStream getInputStream(long offset) throws IOException {
        final SFTPConnectionHandler connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
        try {
            connHandler.checkConnection();
            SftpFile sftpFile = connHandler.sftpSubsystem.openFile(this.absPath, 1);
            return new SftpFileInputStream(sftpFile, offset){

                public void close() throws IOException {
                    super.close();
                    connHandler.releaseLock();
                }
            };
        }
        catch (IOException e) {
            connHandler.releaseLock();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCanonicalPath() {
        if (this.isSymlink()) {
            if (this.canonicalPath != null && System.currentTimeMillis() - this.canonicalPathFetchedTime < attributeCachingPeriod) {
                return this.canonicalPath;
            }
            ConnectionHandler connHandler = null;
            try {
                connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.fileURL, true);
                connHandler.checkConnection();
                String symlinkTargetPath = ((SFTPConnectionHandler)connHandler).sftpSubsystem.getSymbolicLinkTarget(this.fileURL.getPath());
                if (!symlinkTargetPath.startsWith("/")) {
                    String parentPath = this.fileURL.getParent().getPath();
                    if (!parentPath.endsWith("/")) {
                        parentPath = parentPath + "/";
                    }
                    symlinkTargetPath = parentPath + symlinkTargetPath;
                }
                FileURL canonicalURL = (FileURL)this.fileURL.clone();
                canonicalURL.setPath(symlinkTargetPath);
                this.canonicalPath = canonicalURL.toString(false);
                this.canonicalPathFetchedTime = System.currentTimeMillis();
            }
            catch (IOException iOException) {
            }
            finally {
                if (connHandler != null) {
                    connHandler.releaseLock();
                }
            }
        }
        return this.getAbsolutePath();
    }

    private class SFTPRandomAccessInputStream
    extends RandomAccessInputStream {
        private SftpFileInputStream in;

        private SFTPRandomAccessInputStream() throws IOException {
            this.in = (SftpFileInputStream)SFTPFile.this.getInputStream();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public long getOffset() throws IOException {
            return this.in.getPosition();
        }

        public long getLength() throws IOException {
            return SFTPFile.this.getSize();
        }

        public void seek(long offset) throws IOException {
            this.in.setPosition(offset);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    static class SFTPFileAttributes
    extends SyncedFileAttributes {
        private FileURL url;
        private boolean isSymlink;

        private SFTPFileAttributes(FileURL url) throws AuthException {
            super(attributeCachingPeriod, false);
            this.url = url;
            this.setPermissions(FilePermissions.EMPTY_FILE_PERMISSIONS);
            this.fetchAttributes();
            this.updateExpirationDate();
        }

        private SFTPFileAttributes(FileURL url, FileAttributes attrs) {
            super(attributeCachingPeriod, false);
            this.url = url;
            this.setPermissions(FilePermissions.EMPTY_FILE_PERMISSIONS);
            this.setAttributes(attrs);
            this.setExists(true);
            this.isSymlink = attrs.isLink();
            this.updateExpirationDate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchAttributes() throws AuthException {
            ConnectionHandler connHandler = null;
            try {
                connHandler = (SFTPConnectionHandler)ConnectionPool.getConnectionHandler(connHandlerFactory, this.url, true);
                connHandler.checkConnection();
                this.setAttributes(((SFTPConnectionHandler)connHandler).sftpSubsystem.getAttributes(this.url.getPath()));
                this.setExists(true);
            }
            catch (IOException e) {
                this.setExists(false);
                if (e instanceof AuthException) {
                    throw (AuthException)e;
                }
            }
            finally {
                if (connHandler != null) {
                    connHandler.releaseLock();
                }
            }
        }

        private void setAttributes(FileAttributes attrs) {
            this.setDirectory(attrs.isDirectory());
            this.setDate(attrs.getModifiedTime().longValue() * 1000L);
            this.setSize(attrs.getSize().longValue());
            this.setPermissions(new SimpleFilePermissions(attrs.getPermissions().intValue() & 0x1FF));
            this.setOwner(attrs.getUID().toString());
            this.setGroup(attrs.getGID().toString());
            this.setSymlink(this.isSymlink);
        }

        private void addToSize(long increment) {
            this.setSize(this.getSize() + increment);
        }

        private boolean isSymlink() {
            this.checkForExpiration(false);
            return this.isSymlink;
        }

        private void setSymlink(boolean isSymlink) {
            this.isSymlink = isSymlink;
        }

        public void updateAttributes() {
            try {
                this.fetchAttributes();
            }
            catch (Exception e) {
                LOGGER.info("Failed to refresh attributes", e);
            }
        }
    }
}

