/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.Common;

import java.io.IOException;
import java.io.InputStream;

public class InBuffer {
    int _bufferPos;
    int _bufferLimit;
    byte[] _bufferBase;
    InputStream _stream = null;
    long _processedSize;
    int _bufferSize;
    boolean _wasFinished;

    public void Create(int bufferSize) {
        boolean kMinBlockSize = true;
        if (bufferSize < 1) {
            bufferSize = 1;
        }
        if (this._bufferBase != null && this._bufferSize == bufferSize) {
            return;
        }
        this.Free();
        this._bufferSize = bufferSize;
        this._bufferBase = new byte[bufferSize];
    }

    void Free() {
        this._bufferBase = null;
    }

    public void SetStream(InputStream stream) {
        this._stream = stream;
    }

    public void Init() {
        this._processedSize = 0L;
        this._bufferPos = 0;
        this._bufferLimit = 0;
        this._wasFinished = false;
    }

    public void ReleaseStream() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
        this._stream = null;
    }

    public int read() throws IOException {
        if (this._bufferPos >= this._bufferLimit) {
            return this.ReadBlock2();
        }
        return this._bufferBase[this._bufferPos++] & 0xFF;
    }

    public boolean ReadBlock() throws IOException {
        if (this._wasFinished) {
            return false;
        }
        this._processedSize += (long)this._bufferPos;
        int numProcessedBytes = this._stream.read(this._bufferBase, 0, this._bufferSize);
        if (numProcessedBytes == -1) {
            numProcessedBytes = 0;
        }
        this._bufferPos = 0;
        this._bufferLimit = numProcessedBytes;
        this._wasFinished = numProcessedBytes == 0;
        return !this._wasFinished;
    }

    public int ReadBlock2() throws IOException {
        if (!this.ReadBlock()) {
            return -1;
        }
        return this._bufferBase[this._bufferPos++] & 0xFF;
    }

    public long GetProcessedSize() {
        return this._processedSize + (long)this._bufferPos;
    }

    public boolean WasFinished() {
        return this._wasFinished;
    }
}

