/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.Archive.Common;

import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.ICompressCoder;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.ICompressFilter;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.ICompressProgressInfo;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.ICompressSetOutStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilterCoder
extends OutputStream
implements ICompressCoder,
ICompressSetOutStream {
    public ICompressFilter Filter = null;
    OutputStream _outStream = null;
    int _bufferPos;
    boolean _outSizeIsDefined;
    long _outSize;
    long _nowPos64;
    byte[] _buffer = new byte[131072];

    int Init() {
        this._nowPos64 = 0L;
        this._outSizeIsDefined = false;
        return this.Filter.Init();
    }

    public int Code(InputStream inStream, OutputStream outStream, long outSize, ICompressProgressInfo progress) throws IOException {
        throw new IOException("Not implemented");
    }

    public void write(int b) {
        throw new UnknownError("FilterCoder write");
    }

    public void write(byte[] b, int off, int size) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || size < 0 || off + size > b.length || off + size < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (size == 0) {
            return;
        }
        if (off != 0) {
            throw new IOException("FilterCoder - off <> 0");
        }
        byte[] cur_data = b;
        int cur_off = 0;
        while (size > 0) {
            int sizeTemp = size;
            int sizeMax = 131072 - this._bufferPos;
            if (sizeTemp > sizeMax) {
                sizeTemp = sizeMax;
            }
            System.arraycopy(cur_data, cur_off, this._buffer, this._bufferPos, sizeTemp);
            size -= sizeTemp;
            cur_off += sizeTemp;
            int endPos = this._bufferPos + sizeTemp;
            this._bufferPos = this.Filter.Filter(this._buffer, endPos);
            if (this._bufferPos == 0) {
                this._bufferPos = endPos;
                break;
            }
            if (this._bufferPos > endPos) {
                if (size == 0) break;
                throw new IOException("FilterCoder - write() : size  <> 0");
            }
            this.WriteWithLimit(this._outStream, this._bufferPos);
            int i = 0;
            while (this._bufferPos < endPos) {
                this._buffer[i++] = this._buffer[this._bufferPos++];
            }
            this._bufferPos = i;
        }
    }

    void WriteWithLimit(OutputStream outStream, int size) throws IOException {
        long remSize;
        if (this._outSizeIsDefined && (long)size > (remSize = this._outSize - this._nowPos64)) {
            size = (int)remSize;
        }
        outStream.write(this._buffer, 0, size);
        this._nowPos64 += (long)size;
    }

    public int SetOutStream(OutputStream outStream) {
        this._bufferPos = 0;
        this._outStream = outStream;
        return this.Init();
    }

    public void flush() throws IOException {
        if (this._bufferPos != 0) {
            int endPos = this.Filter.Filter(this._buffer, this._bufferPos);
            if (endPos > this._bufferPos) {
                while (this._bufferPos < endPos) {
                    this._buffer[this._bufferPos] = 0;
                    ++this._bufferPos;
                }
                if (this.Filter.Filter(this._buffer, endPos) != endPos) {
                    throw new IOException("FilterCoder - flush() : E_FAIL");
                }
            }
            this._outStream.write(this._buffer, 0, this._bufferPos);
            this._bufferPos = 0;
        }
        this._outStream.flush();
    }

    public void close() throws IOException {
        if (this._outStream != null) {
            this._outStream.close();
        }
        this._outStream = null;
    }
}

