/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sevenzip.provider.Common;

public class CRC {
    public static int[] Table = new int[256];
    int _value = -1;

    public void Init() {
        this._value = -1;
    }

    public void UpdateByte(int b) {
        this._value = Table[(this._value ^ b) & 0xFF] ^ this._value >>> 8;
    }

    public void UpdateUInt32(int v) {
        for (int i = 0; i < 4; ++i) {
            this.UpdateByte(v >> 8 * i & 0xFF);
        }
    }

    public void UpdateUInt64(long v) {
        for (int i = 0; i < 8; ++i) {
            this.UpdateByte((int)(v >> 8 * i) & 0xFF);
        }
    }

    public int GetDigest() {
        return ~this._value;
    }

    public void Update(byte[] data, int size) {
        for (int i = 0; i < size; ++i) {
            this._value = Table[(this._value ^ data[i]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public void Update(byte[] data, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            this._value = Table[(this._value ^ data[offset + i]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public static int CalculateDigest(byte[] data, int size) {
        CRC crc = new CRC();
        crc.Update(data, size);
        return crc.GetDigest();
    }

    public static boolean VerifyDigest(int digest, byte[] data, int size) {
        return CRC.CalculateDigest(data, size) == digest;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int r = i;
            for (int j = 0; j < 8; ++j) {
                if ((r & 1) != 0) {
                    r = r >>> 1 ^ 0xEDB88320;
                    continue;
                }
                r >>>= 1;
            }
            CRC.Table[i] = r;
        }
    }
}

