/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sevenzip;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.IInStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuRandomAccessFile
extends IInStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuRandomAccessFile.class);
    private AbstractFile file;
    private InputStream stream;
    private long position = 0L;

    public MuRandomAccessFile(AbstractFile file) throws UnsupportedFileOperationException {
        this.file = file;
        try {
            this.stream = file.getInputStream();
        }
        catch (IOException e) {
            LOGGER.trace("Error", e);
        }
    }

    public long Seek(long offset, int seekOrigin) throws IOException {
        if (seekOrigin == 0) {
            this.stream.close();
            this.stream = this.file.getInputStream();
            this.stream.skip(offset);
            this.position = offset;
        } else if (seekOrigin == 1) {
            this.stream.skip(offset);
            this.position += offset;
        }
        return this.position;
    }

    public int read() throws IOException {
        int read = this.stream.read();
        this.position += (long)read;
        return read;
    }

    public int read(byte[] data, int off, int size) throws IOException {
        int read = this.stream.read(data, off, size);
        this.position += (long)read;
        return read;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public long skip(long offset) {
        long skipped = 0L;
        try {
            skipped = this.stream.skip(offset);
        }
        catch (IOException e) {
            LOGGER.trace("Error", e);
        }
        return skipped;
    }

    public int available() {
        int available = 0;
        try {
            available = this.stream.available();
        }
        catch (IOException e) {
            LOGGER.trace("Error", e);
        }
        return available;
    }
}

