/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.s3;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.SimpleFileAttributes;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.s3.S3File;
import com.mucommander.commons.io.RandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;

public class S3Root
extends S3File {
    private SimpleFileAttributes atts = new SimpleFileAttributes();
    private static final FilePermissions DEFAULT_PERMISSIONS = new SimpleFilePermissions(448);

    protected S3Root(FileURL url, S3Service service) {
        super(url, service);
        this.atts.setPath("/");
        this.atts.setExists(true);
        this.atts.setDate(0L);
        this.atts.setSize(0L);
        this.atts.setDirectory(true);
        this.atts.setPermissions(DEFAULT_PERMISSIONS);
        this.atts.setOwner(null);
        this.atts.setGroup(null);
    }

    public FileAttributes getFileAttributes() {
        return this.atts;
    }

    public String getOwner() {
        return null;
    }

    public boolean canGetOwner() {
        return false;
    }

    public AbstractFile[] ls() throws IOException {
        try {
            S3Bucket[] buckets = this.service.listAllBuckets();
            int nbBuckets = buckets.length;
            AbstractFile[] bucketFiles = new AbstractFile[nbBuckets];
            for (int i = 0; i < nbBuckets; ++i) {
                FileURL bucketURL = (FileURL)this.fileURL.clone();
                bucketURL.setPath("/" + buckets[i].getName());
                bucketFiles[i] = FileFactory.getFile(bucketURL, null, this.service, buckets[i]);
            }
            return bucketFiles;
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    @UnsupportedFileOperation
    public void mkdir() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CREATE_DIRECTORY);
    }

    @UnsupportedFileOperation
    public InputStream getInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.READ_FILE);
    }

    @UnsupportedFileOperation
    public OutputStream getOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.WRITE_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessInputStream getRandomAccessInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_READ_FILE);
    }

    @UnsupportedFileOperation
    public void delete() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.DELETE);
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public void renameTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RENAME);
    }
}

