/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.s3;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.ProtocolProvider;
import com.mucommander.commons.file.impl.s3.S3Bucket;
import com.mucommander.commons.file.impl.s3.S3File;
import com.mucommander.commons.file.impl.s3.S3Object;
import com.mucommander.commons.file.impl.s3.S3Root;
import java.io.IOException;
import java.util.StringTokenizer;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;

public class S3ProtocolProvider
implements ProtocolProvider {
    public AbstractFile getFile(FileURL url, Object ... instantiationParams) throws IOException {
        S3Service service;
        Credentials credentials = url.getCredentials();
        if (credentials == null || credentials.getLogin().equals("") || credentials.getPassword().equals("")) {
            throw new AuthException(url);
        }
        if (instantiationParams.length == 0) {
            try {
                service = new RestS3Service(new AWSCredentials(credentials.getLogin(), credentials.getPassword()));
                Jets3tProperties props = new Jets3tProperties();
                props.setProperty("s3service.s3-endpoint", url.getHost());
            }
            catch (S3ServiceException e) {
                throw S3File.getIOException(e, url);
            }
        } else {
            service = (S3Service)instantiationParams[0];
        }
        String path = url.getPath();
        if ("/".equals(path)) {
            return new S3Root(url, service);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        String bucketName = st.nextToken();
        if (st.hasMoreTokens()) {
            if (instantiationParams.length == 2) {
                return new S3Object(url, service, bucketName, (org.jets3t.service.model.S3Object)instantiationParams[1]);
            }
            return new S3Object(url, service, bucketName);
        }
        if (instantiationParams.length == 2) {
            return new S3Bucket(url, service, (org.jets3t.service.model.S3Bucket)instantiationParams[1]);
        }
        return new S3Bucket(url, service, bucketName);
    }
}

