/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.nfs;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.GroupedPermissionBits;
import com.mucommander.commons.file.IndividualPermissionBits;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import com.sun.xfile.XRandomAccessFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NFSFile
extends ProtocolFile {
    private XFile file;
    private String absPath;
    private FilePermissions permissions;
    private AbstractFile parent;
    private boolean parentValueSet;

    protected NFSFile(FileURL fileURL) {
        super(fileURL);
        String nfsProtocol;
        String nfsVersion = fileURL.getProperty("version");
        if (nfsVersion == null) {
            nfsVersion = "v2";
        }
        nfsProtocol = "TCP".equals(nfsProtocol = fileURL.getProperty("protocol")) ? "t" : ("UDP".equals(nfsProtocol) ? "u" : "");
        int port = fileURL.getPort();
        String portString = port == -1 || port == 2049 ? "" : "" + port;
        this.file = new XFile("nfs://" + fileURL.getHost() + ":" + portString + nfsVersion + nfsProtocol + "m" + "/" + fileURL.getPath());
        this.absPath = fileURL.toString();
        this.absPath = this.absPath.endsWith("/") ? this.absPath.substring(0, this.absPath.length() - 1) : this.absPath;
        this.permissions = new NFSFilePermissions(this.file);
    }

    public long getDate() {
        return this.file.lastModified();
    }

    @UnsupportedFileOperation
    public void changeDate(long lastModified) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_DATE);
    }

    public long getSize() {
        return this.file.length();
    }

    public AbstractFile getParent() {
        if (!this.parentValueSet) {
            FileURL parentURL = this.getURL().getParent();
            if (parentURL != null) {
                this.parent = FileFactory.getFile(parentURL);
            }
            this.parentValueSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValueSet = true;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public PermissionBits getChangeablePermissions() {
        return PermissionBits.EMPTY_PERMISSION_BITS;
    }

    @UnsupportedFileOperation
    public void changePermission(int access, int permission, boolean enabled) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_PERMISSION);
    }

    public String getOwner() {
        return null;
    }

    public boolean canGetOwner() {
        return false;
    }

    public String getGroup() {
        return null;
    }

    public boolean canGetGroup() {
        return false;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isSymlink() {
        return false;
    }

    public AbstractFile[] ls() throws IOException {
        return this.ls(null);
    }

    public void mkdir() throws IOException {
        if (!new XFile(this.absPath).mkdir()) {
            throw new IOException();
        }
    }

    public InputStream getInputStream() throws IOException {
        return new XFileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new XFileOutputStream(this.absPath, false);
    }

    public OutputStream getAppendOutputStream() throws IOException {
        return new XFileOutputStream(this.absPath, true);
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        return new NFSRandomAccessInputStream(new XRandomAccessFile(this.file, "r"));
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws IOException {
        return new NFSRandomAccessOutputStream(new XRandomAccessFile(this.file, "rw"));
    }

    public void delete() throws IOException {
        boolean ret = this.file.delete();
        if (!ret) {
            throw new IOException();
        }
    }

    public void renameTo(AbstractFile destFile) throws IOException {
        this.checkRenamePrerequisites(destFile, true, false);
        if (!this.file.renameTo(((NFSFile)destFile).file)) {
            throw new IOException();
        }
    }

    public Object getUnderlyingFileObject() {
        return this.file;
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public long getFreeSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_FREE_SPACE);
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    public AbstractFile[] ls(FilenameFilter filenameFilter) throws IOException {
        String[] names = this.file.list();
        if (names == null) {
            throw new IOException();
        }
        if (filenameFilter != null) {
            names = filenameFilter.filter(names);
        }
        AbstractFile[] children = new AbstractFile[names.length];
        String baseURLPath = this.fileURL.getPath();
        if (!baseURLPath.endsWith("/")) {
            baseURLPath = baseURLPath + "/";
        }
        for (int i = 0; i < names.length; ++i) {
            FileURL childURL = (FileURL)this.fileURL.clone();
            childURL.setPath(baseURLPath + names[i]);
            children[i] = FileFactory.getFile(childURL, (AbstractFile)this, new Object[0]);
        }
        return children;
    }

    private static class NFSFilePermissions
    extends IndividualPermissionBits
    implements FilePermissions {
        private XFile file;
        private static final PermissionBits MASK = new GroupedPermissionBits(384);

        public NFSFilePermissions(XFile file) {
            this.file = file;
        }

        public boolean getBitValue(int access, int type) {
            if (access != 2) {
                return false;
            }
            if (type == 4) {
                return this.file.canRead();
            }
            if (type == 2) {
                return this.file.canWrite();
            }
            return false;
        }

        public PermissionBits getMask() {
            return MASK;
        }
    }

    public static class NFSRandomAccessOutputStream
    extends RandomAccessOutputStream {
        private XRandomAccessFile raf;

        public NFSRandomAccessOutputStream(XRandomAccessFile raf) {
            this.raf = raf;
        }

        public void write(int i) throws IOException {
            this.raf.write(i);
        }

        public void write(byte[] b) throws IOException {
            this.raf.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.raf.write(b, off, len);
        }

        public void close() throws IOException {
            this.raf.close();
        }

        public long getOffset() throws IOException {
            return this.raf.getFilePointer();
        }

        public long getLength() throws IOException {
            return this.raf.length();
        }

        public void seek(long offset) throws IOException {
            this.raf.seek(offset);
        }

        public void setLength(long newLength) throws IOException {
            long currentLength = this.getLength();
            if (newLength < currentLength) {
                throw new IOException();
            }
            if (newLength == currentLength) {
                return;
            }
            this.seek(newLength - 1L);
            this.write(0);
        }
    }

    public static class NFSRandomAccessInputStream
    extends RandomAccessInputStream {
        private XRandomAccessFile raf;

        public NFSRandomAccessInputStream(XRandomAccessFile raf) {
            this.raf = raf;
        }

        public int read() throws IOException {
            return this.raf.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.raf.read(b, off, len);
        }

        public void close() throws IOException {
            this.raf.close();
        }

        public long getOffset() throws IOException {
            return this.raf.getFilePointer();
        }

        public long getLength() throws IOException {
            return this.raf.length();
        }

        public void seek(long offset) throws IOException {
            this.raf.seek(offset);
        }
    }
}

