/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.lst;

import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.impl.lst.LstArchiveEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LstArchiveEntryIterator
implements ArchiveEntryIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LstArchiveEntryIterator.class);
    private BufferedReader br;
    private SimpleDateFormat lstDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm.ss");
    private String baseFolder;
    private String currentDir = "";

    LstArchiveEntryIterator(InputStream in) throws IOException {
        this.br = new BufferedReader(new InputStreamReader(in));
        this.baseFolder = this.br.readLine();
        if (this.baseFolder == null) {
            throw new IOException();
        }
    }

    ArchiveEntry getNextEntry() throws IOException {
        String line = this.br.readLine();
        if (line == null) {
            return null;
        }
        try {
            String path;
            boolean isDirectory;
            StringTokenizer st = new StringTokenizer(line, "\t");
            String name = st.nextToken().replace('\\', '/');
            long size = Long.parseLong(st.nextToken());
            long date = this.lstDateFormat.parse(st.nextToken() + " " + st.nextToken()).getTime();
            if (name.endsWith("/")) {
                isDirectory = true;
                path = this.currentDir = name;
            } else {
                isDirectory = false;
                path = this.currentDir + name;
            }
            return new LstArchiveEntry(path, isDirectory, date, size, this.baseFolder);
        }
        catch (Exception e) {
            LOGGER.info("Exception caught while parsing LST file", e);
            throw new IOException();
        }
    }

    public ArchiveEntry nextEntry() throws IOException {
        return this.getNextEntry();
    }

    public void close() throws IOException {
        this.br.close();
    }
}

