/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.local;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.GroupedPermissionBits;
import com.mucommander.commons.file.IndividualPermissionBits;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.Kernel32;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsVersion;
import com.mucommander.commons.runtime.OsVersions;
import com.sun.jna.ptr.LongByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UNCFile
extends ProtocolFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(UNCFile.class);
    protected File file;
    private FilePermissions permissions;
    protected String absPath;
    protected AbstractFile parent;
    protected boolean parentValueSet;
    private static PermissionBits CHANGEABLE_PERMISSIONS_JAVA_1_6_WINDOWS = new GroupedPermissionBits(128);
    private static PermissionBits CHANGEABLE_PERMISSIONS_JAVA_1_5 = PermissionBits.EMPTY_PERMISSION_BITS;
    private static final PermissionBits CHANGEABLE_PERMISSIONS = JavaVersions.JAVA_1_6.isCurrentOrHigher() ? CHANGEABLE_PERMISSIONS_JAVA_1_6_WINDOWS : CHANGEABLE_PERMISSIONS_JAVA_1_5;

    protected UNCFile(FileURL fileURL) throws IOException {
        this(fileURL, null);
    }

    protected UNCFile(FileURL fileURL, File file) throws IOException {
        super(fileURL);
        if (file == null) {
            this.absPath = "\\\\" + fileURL.getHost() + fileURL.getPath().replace('/', '\\');
            file = new File(this.absPath);
            if (!file.isAbsolute()) {
                throw new IOException();
            }
        } else {
            this.absPath = "\\\\" + fileURL.getHost() + fileURL.getPath().replace('/', '\\');
        }
        if (this.absPath.endsWith("\\")) {
            this.absPath = this.absPath.substring(0, this.absPath.length() - 1);
        }
        this.file = file;
        this.permissions = new UNCFilePermissions(file);
    }

    public Object getUnderlyingFileObject() {
        return this.file;
    }

    public boolean isSymlink() {
        return false;
    }

    public long getDate() {
        return this.file.lastModified();
    }

    public void changeDate(long lastModified) throws IOException {
        if (lastModified < 0L) {
            lastModified = 0L;
        }
        if (!this.file.setLastModified(lastModified)) {
            throw new IOException();
        }
    }

    public long getSize() {
        return this.file.length();
    }

    public AbstractFile getParent() {
        if (!this.parentValueSet) {
            FileURL parentURL;
            if (!this.isRoot() && (parentURL = this.getURL().getParent()) != null) {
                this.parent = FileFactory.getFile(parentURL);
            }
            this.parentValueSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValueSet = true;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public PermissionBits getChangeablePermissions() {
        return CHANGEABLE_PERMISSIONS;
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException {
        if (access != 2 || JavaVersions.JAVA_1_6.isCurrentLower()) {
            throw new IOException();
        }
        boolean success = false;
        if (permission == 4) {
            success = this.file.setReadable(enabled);
        } else if (permission == 2) {
            success = this.file.setWritable(enabled);
        } else if (permission == 1) {
            success = this.file.setExecutable(enabled);
        }
        if (!success) {
            throw new IOException();
        }
    }

    public String getOwner() {
        return null;
    }

    public boolean canGetOwner() {
        return false;
    }

    public String getGroup() {
        return null;
    }

    public boolean canGetGroup() {
        return false;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        return new LocalFile.LocalInputStream(new FileInputStream(this.file).getChannel());
    }

    public OutputStream getOutputStream() throws IOException {
        return new LocalFile.LocalOutputStream(new FileOutputStream(this.absPath, false).getChannel());
    }

    public OutputStream getAppendOutputStream() throws IOException {
        return new LocalFile.LocalOutputStream(new FileOutputStream(this.absPath, true).getChannel());
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        return new LocalFile.LocalRandomAccessInputStream(new RandomAccessFile(this.file, "r").getChannel());
    }

    public RandomAccessOutputStream getRandomAccessOutputStream() throws IOException {
        return new LocalFile.LocalRandomAccessOutputStream(new RandomAccessFile(this.file, "rw").getChannel());
    }

    public void delete() throws IOException {
        boolean ret = this.file.delete();
        if (!ret) {
            throw new IOException();
        }
    }

    public AbstractFile[] ls() throws IOException {
        return this.ls((com.mucommander.commons.file.filter.FilenameFilter)null);
    }

    public void mkdir() throws IOException {
        if (!this.file.mkdir()) {
            throw new IOException();
        }
    }

    public void renameTo(AbstractFile destFile) throws IOException, UnsupportedFileOperationException {
        this.checkRenamePrerequisites(destFile, true, false);
        destFile = destFile.getTopAncestor();
        File destJavaIoFile = ((UNCFile)destFile).file;
        if (!this.getRoot().equals(destFile.getRoot())) {
            throw new IOException();
        }
        if (OsVersions.WINDOWS_ME.isCurrentOrLower()) {
            if (destFile.exists() && !destJavaIoFile.delete()) {
                throw new IOException();
            }
        } else if (Kernel32.isAvailable()) {
            if (!Kernel32.getInstance().MoveFileEx(this.absPath, destFile.getAbsolutePath(), 9)) {
                String errorMessage = Integer.toString(Kernel32.getInstance().GetLastError());
                throw new IOException("Rename using Kernel32 API failed: " + errorMessage);
            }
            return;
        }
        if (!this.file.renameTo(destJavaIoFile)) {
            throw new IOException();
        }
    }

    public long getFreeSpace() throws IOException {
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return this.file.getUsableSpace();
        }
        return this.getVolumeInfo()[1];
    }

    public long getTotalSpace() throws IOException {
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return this.file.getTotalSpace();
        }
        return this.getVolumeInfo()[0];
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    public String getName() {
        if (this.isRoot()) {
            return this.absPath;
        }
        return this.file.getName();
    }

    public String getAbsolutePath() {
        if (this.isDirectory() && !this.absPath.endsWith("\\")) {
            return this.absPath + "\\";
        }
        return this.absPath;
    }

    public String getCanonicalPath() {
        try {
            String canonicalPath = this.file.getCanonicalPath();
            if (this.isDirectory() && !canonicalPath.endsWith("\\")) {
                canonicalPath = canonicalPath + "\\";
            }
            return canonicalPath;
        }
        catch (IOException e) {
            return this.absPath;
        }
    }

    public String getSeparator() {
        return "\\";
    }

    public AbstractFile[] ls(com.mucommander.commons.file.filter.FilenameFilter filenameFilter) throws IOException {
        File[] files = this.file.listFiles(filenameFilter == null ? null : new UNCFilenameFilter(filenameFilter));
        if (files == null) {
            throw new IOException();
        }
        int nbFiles = files.length;
        AbstractFile[] children = new AbstractFile[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            File file = files[i];
            FileURL childURL = (FileURL)this.fileURL.clone();
            childURL.setPath(this.addTrailingSeparator(this.fileURL.getPath()) + file.getName());
            children[i] = FileFactory.getFile(childURL, (AbstractFile)this, file);
        }
        return children;
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public AbstractFile getRoot() {
        String[] splittedBySeparator = this.absPath.split("\\\\");
        return FileFactory.getFile("\\\\" + splittedBySeparator[2] + "\\" + splittedBySeparator[3]);
    }

    public boolean isRoot() {
        return this.countIndexOf(this.absPath, "\\\\") <= 3;
    }

    private int countIndexOf(String text, String search) {
        return text.split(search).length - 1;
    }

    public AbstractFile getVolume() {
        AbstractFile[] volumes = LocalFile.getVolumes();
        int bestDepth = -1;
        int bestMatch = -1;
        String thisPath = this.getAbsolutePath(true);
        for (int i = 0; i < volumes.length; ++i) {
            int depth;
            AbstractFile volume = volumes[i];
            String volumePath = volume.getAbsolutePath(true);
            if (thisPath.equals(volumePath)) {
                return this;
            }
            if (!thisPath.startsWith(volumePath) || (depth = PathUtils.getDepth(volumePath, volume.getSeparator())) <= bestDepth) continue;
            bestDepth = depth;
            bestMatch = i;
        }
        if (bestMatch != -1) {
            return volumes[bestMatch];
        }
        return this.getRoot();
    }

    public long[] getVolumeInfo() throws IOException {
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return new long[]{this.getTotalSpace(), this.getFreeSpace()};
        }
        return this.getNativeVolumeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getNativeVolumeInfo() throws IOException {
        BufferedReader br = null;
        String absPath = this.getAbsolutePath();
        long[] dfInfo = new long[]{-1L, -1L};
        try {
            Process process;
            if (Kernel32.isAvailable()) {
                LongByReference totalSpaceLBR = new LongByReference();
                LongByReference freeSpaceLBR = new LongByReference();
                if (Kernel32.getInstance().GetDiskFreeSpaceEx(absPath, null, totalSpaceLBR, freeSpaceLBR)) {
                    dfInfo[0] = totalSpaceLBR.getValue();
                    dfInfo[1] = freeSpaceLBR.getValue();
                } else {
                    LOGGER.warn("Call to GetDiskFreeSpaceEx failed, absPath={}", absPath);
                }
            } else if (OsVersions.WINDOWS_NT.isCurrentOrHigher() && (process = Runtime.getRuntime().exec((OsVersion.getCurrent().compareTo(OsVersion.WINDOWS_NT) >= 0 ? "cmd /c" : "command.com /c") + " dir \"" + absPath + "\"")) != null) {
                String line;
                br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String lastLine = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    lastLine = line;
                }
                if (lastLine != null) {
                    StringTokenizer st = new StringTokenizer(lastLine, " \t\n\r\f,.");
                    st.nextToken();
                    String freeSpace = "";
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        char c = token.charAt(0);
                        if (c >= '0' && c <= '9') {
                            freeSpace = freeSpace + token;
                            continue;
                        }
                        if (freeSpace.equals("")) continue;
                        break;
                    }
                    dfInfo[1] = Long.parseLong(freeSpace);
                }
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return dfInfo;
    }

    private static class UNCFilenameFilter
    implements FilenameFilter {
        private com.mucommander.commons.file.filter.FilenameFilter filter;

        private UNCFilenameFilter(com.mucommander.commons.file.filter.FilenameFilter filter) {
            this.filter = filter;
        }

        public boolean accept(File dir, String name) {
            return this.filter.accept(name);
        }
    }

    private static class UNCFilePermissions
    extends IndividualPermissionBits
    implements FilePermissions {
        private File file;
        private static PermissionBits JAVA_1_6_PERMISSIONS = new GroupedPermissionBits(448);
        private static PermissionBits JAVA_1_5_PERMISSIONS = new GroupedPermissionBits(384);
        private static final PermissionBits MASK = JavaVersions.JAVA_1_6.isCurrentOrHigher() ? JAVA_1_6_PERMISSIONS : JAVA_1_5_PERMISSIONS;

        private UNCFilePermissions(File file) {
            this.file = file;
        }

        public boolean getBitValue(int access, int type) {
            if (access != 2) {
                return false;
            }
            if (type == 4) {
                return this.file.canRead();
            }
            if (type == 2) {
                return this.file.canWrite();
            }
            if (type == 1 && JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
                return this.file.canExecute();
            }
            return false;
        }

        public int getIntValue() {
            int userPerms = 0;
            if (this.getBitValue(2, 4)) {
                userPerms |= 4;
            }
            if (this.getBitValue(2, 2)) {
                userPerms |= 2;
            }
            if (this.getBitValue(2, 1)) {
                userPerms |= 1;
            }
            return userPerms << 6;
        }

        public PermissionBits getMask() {
            return MASK;
        }
    }
}

