/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.local;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.GroupedPermissionBits;
import com.mucommander.commons.file.IndividualPermissionBits;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.util.Kernel32;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.FilteredOutputStream;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsFamily;
import com.mucommander.commons.runtime.OsVersion;
import com.mucommander.commons.runtime.OsVersions;
import com.sun.jna.ptr.LongByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFile
extends ProtocolFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFile.class);
    protected File file;
    private FilePermissions permissions;
    protected String absPath;
    protected AbstractFile parent;
    protected boolean parentValueSet;
    public static final String SEPARATOR = File.separator;
    private static final boolean IS_WINDOWS = OsFamilies.WINDOWS.isCurrent();
    public static final boolean USES_ROOT_DRIVES = IS_WINDOWS || OsFamilies.OS_2.isCurrent();
    static final Pattern DRIVE_ROOT_PATTERN = Pattern.compile("^[a-zA-Z]{1}[:]{1}[\\\\]{1}");
    private static PermissionBits CHANGEABLE_PERMISSIONS_JAVA_1_6_NON_WINDOWS = new GroupedPermissionBits(448);
    private static PermissionBits CHANGEABLE_PERMISSIONS_JAVA_1_6_WINDOWS = new GroupedPermissionBits(128);
    private static PermissionBits CHANGEABLE_PERMISSIONS_JAVA_1_5 = PermissionBits.EMPTY_PERMISSION_BITS;
    private static final PermissionBits CHANGEABLE_PERMISSIONS = JavaVersions.JAVA_1_6.isCurrentOrHigher() ? (IS_WINDOWS ? CHANGEABLE_PERMISSIONS_JAVA_1_6_WINDOWS : CHANGEABLE_PERMISSIONS_JAVA_1_6_NON_WINDOWS) : CHANGEABLE_PERMISSIONS_JAVA_1_5;
    public static final String[] KNOWN_UNIX_FS = new String[]{"adfs", "affs", "autofs", "cifs", "coda", "cramfs", "debugfs", "efs", "ext2", "ext3", "fuseblk", "hfs", "hfsplus", "hpfs", "iso9660", "jfs", "minix", "msdos", "ncpfs", "nfs", "nfs4", "ntfs", "qnx4", "reiserfs", "smbfs", "udf", "ufs", "usbfs", "vfat", "xfs"};

    protected LocalFile(FileURL fileURL) throws IOException {
        this(fileURL, null);
    }

    protected LocalFile(FileURL fileURL, File file) throws IOException {
        super(fileURL);
        if (file == null) {
            String path = fileURL.getPath();
            if (USES_ROOT_DRIVES) {
                path = path.substring(1, path.length());
            }
            if (!(file = new File(path)).isAbsolute()) {
                throw new IOException();
            }
            this.absPath = file.getAbsolutePath();
            if (this.absPath.endsWith(SEPARATOR)) {
                this.absPath = this.absPath.substring(0, this.absPath.length() - 1);
            }
        } else {
            this.absPath = fileURL.getPath();
            if (USES_ROOT_DRIVES) {
                this.absPath = this.absPath.substring(1, this.absPath.length());
            }
        }
        this.file = file;
        this.permissions = new LocalFilePermissions(file);
    }

    public static AbstractFile getUserHome() {
        String userHomePath = System.getProperty("user.home");
        if (userHomePath == null) {
            return null;
        }
        return FileFactory.getFile(userHomePath);
    }

    public long[] getVolumeInfo() throws IOException {
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return new long[]{this.getTotalSpace(), this.getFreeSpace()};
        }
        return this.getNativeVolumeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getNativeVolumeInfo() throws IOException {
        BufferedReader br = null;
        String absPath = this.getAbsolutePath();
        long[] dfInfo = new long[]{-1L, -1L};
        try {
            Process process;
            if (IS_WINDOWS) {
                Process process2;
                if (Kernel32.isAvailable()) {
                    LongByReference totalSpaceLBR = new LongByReference();
                    LongByReference freeSpaceLBR = new LongByReference();
                    if (Kernel32.getInstance().GetDiskFreeSpaceEx(absPath, null, totalSpaceLBR, freeSpaceLBR)) {
                        dfInfo[0] = totalSpaceLBR.getValue();
                        dfInfo[1] = freeSpaceLBR.getValue();
                    } else {
                        LOGGER.warn("Call to GetDiskFreeSpaceEx failed, absPath={}", absPath);
                    }
                } else if (OsVersions.WINDOWS_NT.isCurrentOrHigher() && (process2 = Runtime.getRuntime().exec((OsVersion.getCurrent().compareTo(OsVersion.WINDOWS_NT) >= 0 ? "cmd /c" : "command.com /c") + " dir \"" + absPath + "\"")) != null) {
                    String line;
                    br = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                    String lastLine = null;
                    while ((line = br.readLine()) != null) {
                        if (line.trim().equals("")) continue;
                        lastLine = line;
                    }
                    if (lastLine != null) {
                        StringTokenizer st = new StringTokenizer(lastLine, " \t\n\r\f,.");
                        st.nextToken();
                        String freeSpace = "";
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            char c = token.charAt(0);
                            if (c >= '0' && c <= '9') {
                                freeSpace = freeSpace + token;
                                continue;
                            }
                            if (freeSpace.equals("")) continue;
                            break;
                        }
                        dfInfo[1] = Long.parseLong(freeSpace);
                    }
                }
            } else if (OsFamily.getCurrent().isUnixBased() && (process = Runtime.getRuntime().exec(new String[]{"df", "-P", "-k", absPath}, null, this.file)) != null) {
                int nbTokens;
                br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                br.readLine();
                String line = br.readLine();
                Vector<String> tokenV = new Vector<String>();
                if (line != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        tokenV.add(st.nextToken());
                    }
                }
                if ((nbTokens = tokenV.size()) < 6) {
                    LOGGER.warn("Failed to parse output of df -k {} line={}", absPath, line);
                    long[] token = dfInfo;
                    return token;
                }
                int pos = nbTokens - 1;
                while (!((String)tokenV.elementAt(pos)).startsWith("/")) {
                    if (pos == 0) {
                        LOGGER.warn("Failed to parse output of df -k {} line={}", absPath, line);
                        long[] lArray = dfInfo;
                        return lArray;
                    }
                    --pos;
                }
                dfInfo[0] = Long.parseLong((String)tokenV.elementAt(pos - 4)) * 1024L;
                dfInfo[1] = Long.parseLong((String)tokenV.elementAt(pos - 2)) * 1024L;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return dfInfo;
    }

    public boolean guessRemovableDrive() {
        int driveType;
        if (IS_WINDOWS && Kernel32.isAvailable() && (driveType = Kernel32.getInstance().GetDriveType(this.getAbsolutePath(true))) != 0) {
            return driveType == 2 || driveType == 5;
        }
        return LocalFile.hasRootDrives() && this.isRoot() && !this.file.canWrite();
    }

    public static boolean hasRootDrives() {
        return IS_WINDOWS || OsFamilies.OS_2.isCurrent() || "\\".equals(SEPARATOR);
    }

    public static AbstractFile[] getVolumes() {
        Vector<AbstractFile> volumesV = new Vector<AbstractFile>();
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            LocalFile.addMacOSXVolumes(volumesV);
        } else {
            LocalFile.addJavaIoFileRoots(volumesV);
            if (OsFamily.getCurrent().isUnixBased()) {
                LocalFile.addMountEntries(volumesV);
            }
        }
        AbstractFile homeFolder = LocalFile.getUserHome();
        if (homeFolder != null && !volumesV.contains(homeFolder)) {
            volumesV.add(homeFolder);
        }
        AbstractFile[] volumes = new AbstractFile[volumesV.size()];
        volumesV.toArray(volumes);
        return volumes;
    }

    private static void addJavaIoFileRoots(Vector<AbstractFile> v) {
        File[] fileRoots = File.listRoots();
        int nbFolders = fileRoots.length;
        for (int i = 0; i < nbFolders; ++i) {
            try {
                v.add(FileFactory.getFile(fileRoots[i].getAbsolutePath(), true));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMountEntries(Vector<AbstractFile> v) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/mounts")));
            while ((line = br.readLine()) != null) {
                AbstractFile file;
                line = line.trim();
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                String mountPoint = st.nextToken().replace("\\040", " ");
                String fsType = st.nextToken();
                boolean knownFS = false;
                for (String fs : KNOWN_UNIX_FS) {
                    if (!fs.equals(fsType)) continue;
                    knownFS = true;
                    break;
                }
                if (!knownFS || (file = FileFactory.getFile(mountPoint)) == null || v.contains(file)) continue;
                v.add(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing /proc/mounts entries", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void addMacOSXVolumes(Vector<AbstractFile> v) {
        AbstractFile volumesFolder = FileFactory.getFile("/Volumes");
        if (volumesFolder == null) {
            return;
        }
        try {
            for (AbstractFile folder : volumesFolder.ls()) {
                if (!folder.isDirectory()) continue;
                if (folder.getCanonicalPath().equals("/")) {
                    v.insertElementAt(folder, 0);
                    continue;
                }
                v.add(folder);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Can't get /Volumes subfolders", e);
        }
    }

    @Override
    public Object getUnderlyingFileObject() {
        return this.file;
    }

    @Override
    public boolean isSymlink() {
        if (IS_WINDOWS) {
            return false;
        }
        AbstractFile parent = this.getParent();
        String canonPath = this.getCanonicalPath(false);
        if (parent == null || canonPath == null) {
            return false;
        }
        String parentCanonPath = parent.getCanonicalPath(true);
        return !canonPath.equalsIgnoreCase(parentCanonPath + this.getName());
    }

    @Override
    public long getDate() {
        return this.file.lastModified();
    }

    @Override
    public void changeDate(long lastModified) throws IOException {
        if (lastModified < 0L) {
            lastModified = 0L;
        }
        if (!this.file.setLastModified(lastModified)) {
            throw new IOException();
        }
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public AbstractFile getParent() {
        if (!this.parentValueSet) {
            FileURL parentURL;
            if (!this.isRoot() && (parentURL = this.getURL().getParent()) != null) {
                this.parent = FileFactory.getFile(parentURL);
            }
            this.parentValueSet = true;
        }
        return this.parent;
    }

    @Override
    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValueSet = true;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public FilePermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public PermissionBits getChangeablePermissions() {
        return CHANGEABLE_PERMISSIONS;
    }

    @Override
    public void changePermission(int access, int permission, boolean enabled) throws IOException {
        if (access != 2 || JavaVersions.JAVA_1_6.isCurrentLower()) {
            throw new IOException();
        }
        boolean success = false;
        if (permission == 4) {
            success = this.file.setReadable(enabled);
        } else if (permission == 2) {
            success = this.file.setWritable(enabled);
        } else if (permission == 1) {
            success = this.file.setExecutable(enabled);
        }
        if (!success) {
            throw new IOException();
        }
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public boolean canGetOwner() {
        return false;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public boolean canGetGroup() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new LocalInputStream(new FileInputStream(this.file).getChannel());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new LocalOutputStream(new FileOutputStream(this.absPath, false).getChannel());
    }

    @Override
    public OutputStream getAppendOutputStream() throws IOException {
        return new LocalOutputStream(new FileOutputStream(this.absPath, true).getChannel());
    }

    @Override
    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        return new LocalRandomAccessInputStream(new RandomAccessFile(this.file, "r").getChannel());
    }

    @Override
    public RandomAccessOutputStream getRandomAccessOutputStream() throws IOException {
        return new LocalRandomAccessOutputStream(new RandomAccessFile(this.file, "rw").getChannel());
    }

    @Override
    public void delete() throws IOException {
        boolean ret = this.file.delete();
        if (!ret) {
            throw new IOException();
        }
    }

    @Override
    public AbstractFile[] ls() throws IOException {
        return this.ls((com.mucommander.commons.file.filter.FilenameFilter)null);
    }

    @Override
    public void mkdir() throws IOException {
        if (!this.file.mkdir()) {
            throw new IOException();
        }
    }

    @Override
    public void renameTo(AbstractFile destFile) throws IOException, UnsupportedFileOperationException {
        this.checkRenamePrerequisites(destFile, true, false);
        destFile = destFile.getTopAncestor();
        File destJavaIoFile = ((LocalFile)destFile).file;
        if (IS_WINDOWS) {
            if (!this.getRoot().equals(destFile.getRoot())) {
                throw new IOException();
            }
            if (OsVersions.WINDOWS_ME.isCurrentOrLower()) {
                if (destFile.exists() && !destJavaIoFile.delete()) {
                    throw new IOException();
                }
            } else if (Kernel32.isAvailable()) {
                if (!Kernel32.getInstance().MoveFileEx(this.absPath, destFile.getAbsolutePath(), 9)) {
                    String errorMessage = Integer.toString(Kernel32.getInstance().GetLastError());
                    throw new IOException("Rename using Kernel32 API failed: " + errorMessage);
                }
                return;
            }
        }
        if (!this.file.renameTo(destJavaIoFile)) {
            throw new IOException();
        }
    }

    @Override
    public long getFreeSpace() throws IOException {
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return this.file.getUsableSpace();
        }
        return this.getVolumeInfo()[1];
    }

    @Override
    public long getTotalSpace() throws IOException {
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return this.file.getTotalSpace();
        }
        return this.getVolumeInfo()[0];
    }

    @Override
    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @Override
    public String getName() {
        if (this.isRoot()) {
            return LocalFile.hasRootDrives() ? this.absPath : "/";
        }
        return this.file.getName();
    }

    @Override
    public String getAbsolutePath() {
        if (this.isRoot() || this.isDirectory() && !this.absPath.endsWith(SEPARATOR)) {
            return this.absPath + SEPARATOR;
        }
        return this.absPath;
    }

    @Override
    public String getCanonicalPath() {
        try {
            String canonicalPath = this.file.getCanonicalPath();
            if (this.isDirectory() && !canonicalPath.endsWith(SEPARATOR)) {
                canonicalPath = canonicalPath + SEPARATOR;
            }
            return canonicalPath;
        }
        catch (IOException e) {
            return this.absPath;
        }
    }

    @Override
    public String getSeparator() {
        return SEPARATOR;
    }

    @Override
    public AbstractFile[] ls(com.mucommander.commons.file.filter.FilenameFilter filenameFilter) throws IOException {
        File[] files = this.file.listFiles(filenameFilter == null ? null : new LocalFilenameFilter(filenameFilter));
        if (files == null) {
            throw new IOException();
        }
        int nbFiles = files.length;
        AbstractFile[] children = new AbstractFile[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            FileURL childURL = (FileURL)this.fileURL.clone();
            childURL.setPath(this.absPath + SEPARATOR + files[i].getName());
            children[i] = FileFactory.getFile(childURL, (AbstractFile)this, files[i]);
        }
        return children;
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public AbstractFile getRoot() {
        if (USES_ROOT_DRIVES) {
            Matcher matcher = DRIVE_ROOT_PATTERN.matcher(this.absPath + SEPARATOR);
            if (matcher.matches()) {
                return this;
            }
            matcher.reset();
            if (matcher.find()) {
                return FileFactory.getFile(matcher.group());
            }
        }
        return super.getRoot();
    }

    @Override
    public boolean isRoot() {
        if (USES_ROOT_DRIVES) {
            return DRIVE_ROOT_PATTERN.matcher(this.absPath + SEPARATOR).matches();
        }
        return super.isRoot();
    }

    @Override
    public AbstractFile getVolume() {
        AbstractFile[] volumes = LocalFile.getVolumes();
        int bestDepth = -1;
        int bestMatch = -1;
        String thisPath = this.getAbsolutePath(true);
        for (int i = 0; i < volumes.length; ++i) {
            int depth;
            AbstractFile volume = volumes[i];
            String volumePath = volume.getAbsolutePath(true);
            if (thisPath.equals(volumePath)) {
                return this;
            }
            if (!thisPath.startsWith(volumePath) || (depth = PathUtils.getDepth(volumePath, volume.getSeparator())) <= bestDepth) continue;
            bestDepth = depth;
            bestMatch = i;
        }
        if (bestMatch != -1) {
            return volumes[bestMatch];
        }
        return this.getRoot();
    }

    static {
        if (IS_WINDOWS && Kernel32.isAvailable()) {
            Kernel32.getInstance().SetErrorMode(32769);
        }
    }

    private static class LocalFilenameFilter
    implements FilenameFilter {
        private com.mucommander.commons.file.filter.FilenameFilter filter;

        private LocalFilenameFilter(com.mucommander.commons.file.filter.FilenameFilter filter) {
            this.filter = filter;
        }

        public boolean accept(File dir, String name) {
            return this.filter.accept(name);
        }
    }

    private static class LocalFilePermissions
    extends IndividualPermissionBits
    implements FilePermissions {
        private File file;
        private static PermissionBits JAVA_1_6_PERMISSIONS = new GroupedPermissionBits(448);
        private static PermissionBits JAVA_1_5_PERMISSIONS = new GroupedPermissionBits(384);
        private static final PermissionBits MASK = JavaVersions.JAVA_1_6.isCurrentOrHigher() ? JAVA_1_6_PERMISSIONS : JAVA_1_5_PERMISSIONS;

        private LocalFilePermissions(File file) {
            this.file = file;
        }

        public boolean getBitValue(int access, int type) {
            if (access != 2) {
                return false;
            }
            if (type == 4) {
                return this.file.canRead();
            }
            if (type == 2) {
                return this.file.canWrite();
            }
            if (type == 1 && JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
                return this.file.canExecute();
            }
            return false;
        }

        public int getIntValue() {
            int userPerms = 0;
            if (this.getBitValue(2, 4)) {
                userPerms |= 4;
            }
            if (this.getBitValue(2, 2)) {
                userPerms |= 2;
            }
            if (this.getBitValue(2, 1)) {
                userPerms |= 1;
            }
            return userPerms << 6;
        }

        public PermissionBits getMask() {
            return MASK;
        }
    }

    public static class LocalRandomAccessOutputStream
    extends RandomAccessOutputStream {
        private final FileChannel channel;
        private final ByteBuffer bb;

        public LocalRandomAccessOutputStream(FileChannel channel) {
            this.channel = channel;
            this.bb = BufferPool.getByteBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int i) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                this.bb.position(0);
                this.bb.limit(1);
                this.bb.put((byte)i);
                this.bb.position(0);
                this.channel.write(this.bb);
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                int nbToWrite;
                do {
                    this.bb.position(0);
                    nbToWrite = Math.min(this.bb.capacity(), len);
                    this.bb.limit(nbToWrite);
                    this.bb.put(b, off, nbToWrite);
                    this.bb.position(0);
                    nbToWrite = this.channel.write(this.bb);
                    off += nbToWrite;
                } while ((len -= nbToWrite) > 0);
            }
        }

        public void setLength(long newLength) throws IOException {
            long currentLength = this.getLength();
            if (newLength == currentLength) {
                return;
            }
            long currentPos = this.channel.position();
            if (newLength < currentLength) {
                this.channel.truncate(newLength);
                if (currentPos > newLength) {
                    this.channel.position(newLength);
                }
            } else {
                this.channel.position(newLength - 1L);
                this.write(0);
                this.channel.position(currentPos);
            }
        }

        public void close() throws IOException {
            BufferPool.releaseByteBuffer(this.bb);
            this.channel.close();
        }

        public long getOffset() throws IOException {
            return this.channel.position();
        }

        public long getLength() throws IOException {
            return this.channel.size();
        }

        public void seek(long offset) throws IOException {
            this.channel.position(offset);
        }
    }

    public static class LocalOutputStream
    extends FilteredOutputStream {
        public LocalOutputStream(FileChannel channel) {
            super(new LocalRandomAccessOutputStream(channel));
        }
    }

    public static class LocalInputStream
    extends FilterInputStream {
        public LocalInputStream(FileChannel channel) {
            super(new LocalRandomAccessInputStream(channel));
        }
    }

    public static class LocalRandomAccessInputStream
    extends RandomAccessInputStream {
        private final FileChannel channel;
        private final ByteBuffer bb;

        public LocalRandomAccessInputStream(FileChannel channel) {
            this.channel = channel;
            this.bb = BufferPool.getByteBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                this.bb.position(0);
                this.bb.limit(1);
                int nbRead = this.channel.read(this.bb);
                if (nbRead <= 0) {
                    return nbRead;
                }
                return 0xFF & this.bb.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                this.bb.position(0);
                this.bb.limit(Math.min(this.bb.capacity(), len));
                int nbRead = this.channel.read(this.bb);
                if (nbRead <= 0) {
                    return nbRead;
                }
                this.bb.position(0);
                this.bb.get(b, off, nbRead);
                return nbRead;
            }
        }

        public void close() throws IOException {
            BufferPool.releaseByteBuffer(this.bb);
            this.channel.close();
        }

        public long getOffset() throws IOException {
            return this.channel.position();
        }

        public long getLength() throws IOException {
            return this.channel.size();
        }

        public void seek(long offset) throws IOException {
            this.channel.position(offset);
        }
    }
}

