/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.hadoop;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.impl.hadoop.HadoopFile;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class HDFSFile
extends HadoopFile {
    private static String DEFAULT_USERNAME;
    private static String DEFAULT_GROUP;
    private static final FilePermissions DEFAULT_PERMISSIONS;

    protected HDFSFile(FileURL url) throws IOException {
        super(url);
    }

    protected HDFSFile(FileURL url, FileSystem fs, FileStatus fileStatus) throws IOException {
        super(url, fs, fileStatus);
    }

    public static String getDefaultUsername() {
        return DEFAULT_USERNAME;
    }

    public static String getDefaultGroup() {
        return DEFAULT_GROUP;
    }

    private static String getUsername(FileURL url) {
        String username;
        Credentials credentials = url.getCredentials();
        if (credentials == null || (username = credentials.getLogin()).equals("")) {
            username = HDFSFile.getDefaultUsername();
        }
        return username;
    }

    private static String getGroup(FileURL url) {
        return HDFSFile.getDefaultGroup();
    }

    protected FileSystem getHadoopFileSystem(FileURL url) throws IOException {
        FileURL realm = url.getRealm();
        Configuration conf = new Configuration();
        conf.setStrings("hadoop.job.ugi", HDFSFile.getUsername(url), HDFSFile.getGroup(url));
        return FileSystem.get(URI.create(realm.toString(false)), conf);
    }

    protected void setDefaultFileAttributes(FileURL url, HadoopFile.HadoopFileAttributes atts) {
        atts.setOwner(HDFSFile.getUsername(url));
        atts.setGroup(HDFSFile.getGroup(url));
        atts.setPermissions(DEFAULT_PERMISSIONS);
    }

    static {
        DEFAULT_PERMISSIONS = new SimpleFilePermissions(FsPermission.getDefault().applyUMask(FsPermission.getUMask(DEFAULT_CONFIGURATION)).toShort() & 0x1FF);
        try {
            UnixUserGroupInformation ugi = UnixUserGroupInformation.login(DEFAULT_CONFIGURATION);
            DEFAULT_USERNAME = ugi.getUserName();
        }
        catch (Exception e) {
            DEFAULT_USERNAME = System.getProperty("user.name");
        }
        DEFAULT_GROUP = DEFAULT_CONFIGURATION.get("dfs.permissions.supergroup", "supergroup");
    }
}

